/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.codec.jpeg;

import com.alibaba.simpleimage.codec.jpeg.JPEGMarkerException;
import com.alibaba.simpleimage.io.ImageInputStream;
import java.io.IOException;

public class HuffmanTable {
    public static final int TYPE_DC = 0;
    public static final int TYPE_AC = 1;
    private int Lh;
    private int Tc;
    private int Th;
    private int[] L;
    private int[] V;
    private int[] mincode = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private int[] maxcode = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private int[] valptr = new int[17];
    private int[] huffcode = new int[257];
    private int[] huffsize = new int[257];

    public HuffmanTable(int Tc, int Th, int[] bits, int[] huffval) {
        this.Tc = Tc;
        this.Th = Th;
        this.L = bits;
        this.V = huffval;
        this.init();
    }

    private void init() {
        this.generalHuffsize();
        this.generalHuffcode();
        int i = 0;
        int j = 0;
        while (++i <= 16) {
            if (this.L[i] == 0) {
                this.maxcode[i] = -1;
                continue;
            }
            this.valptr[i] = j;
            this.mincode[i] = this.huffcode[j];
            j = j + this.L[i] - 1;
            this.maxcode[i] = this.huffcode[j];
            ++j;
        }
        this.maxcode[17] = 0xFFFFFF;
    }

    private void generalHuffcode() {
        int k = 0;
        int code = 0;
        int si = this.huffsize[0];
        while (true) {
            this.huffcode[k] = code++;
            if (this.huffsize[++k] == si) continue;
            if (this.huffsize[k] == 0) break;
            do {
                code <<= 1;
            } while (this.huffsize[k] != ++si);
        }
    }

    private void generalHuffsize() {
        int k = 0;
        int i = 1;
        int j = 1;
        while (true) {
            if (j <= this.L[i]) {
                this.huffsize[k] = i;
                ++k;
                ++j;
                continue;
            }
            j = 1;
            if (++i > 16) break;
        }
        this.huffsize[k] = 0;
    }

    public int decode(ImageInputStream in) throws IOException, JPEGMarkerException {
        int i = 1;
        int j = 0;
        int code = 0;
        int value = 0;
        code = in.readBit();
        while (code > this.maxcode[i]) {
            ++i;
            code = code << 1 | in.readBit();
        }
        j = this.valptr[i];
        j = j + code - this.mincode[i];
        value = this.V[j];
        return value;
    }

    public int extend(int diff, int t) {
        int Vt = 1 << t - 1;
        if (diff < Vt) {
            Vt = (-1 << t) + 1;
            diff += Vt;
        }
        return diff;
    }

    public int getLh() {
        return this.Lh;
    }

    public void setLh(int lh) {
        this.Lh = lh;
    }

    public int getTc() {
        return this.Tc;
    }

    public void setTc(int tc) {
        this.Tc = tc;
    }

    public int getTh() {
        return this.Th;
    }

    public void setTh(int th) {
        this.Th = th;
    }

    public int[] getL() {
        return this.L;
    }

    public void setL(int[] l) {
        this.L = l;
    }

    public int[] getV() {
        return this.V;
    }

    public void setV(int[] v) {
        this.V = v;
    }
}

