/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.harris.match;

import com.alibaba.simpleimage.analyze.harissurf.SURFInterestPointN;
import java.util.Comparator;

public class SurfMatch {
    int slopeArc;
    SURFInterestPointN sp1;
    SURFInterestPointN sp2;
    double dist1;
    double dist2;

    public SURFInterestPointN getSp1() {
        return this.sp1;
    }

    public SURFInterestPointN getSp2() {
        return this.sp2;
    }

    public double getDist1() {
        return this.dist1;
    }

    public double getDist2() {
        return this.dist2;
    }

    public SurfMatch(SURFInterestPointN sp1, SURFInterestPointN sp2, double dist1, double dist2) {
        this.sp1 = sp1;
        this.sp2 = sp2;
        this.dist1 = dist1;
        this.dist2 = dist2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchWeighter
    implements Comparator<SurfMatch> {
        private double distExp;
        private double quotExp;

        public MatchWeighter() {
            this(1.0, 1.0);
        }

        public MatchWeighter(double distExp, double quotExp) {
            this.distExp = distExp;
            this.quotExp = quotExp;
        }

        public double OverallFitness(SurfMatch m) {
            double fitness = Math.pow(m.getDist1(), this.distExp) * Math.pow(1.0 / (m.getDist2() - m.getDist1()), this.quotExp);
            return fitness;
        }

        @Override
        public int compare(SurfMatch o1, SurfMatch o2) {
            double fit2;
            double fit1 = this.OverallFitness(o1);
            if (fit1 < (fit2 = this.OverallFitness(o2))) {
                return -1;
            }
            if (fit1 > fit2) {
                return 1;
            }
            return 0;
        }
    }
}

