/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.harris;

import com.alibaba.simpleimage.analyze.harissurf.IntegralImage;
import com.alibaba.simpleimage.analyze.harris.Corner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HarrisFast {
    public List<Corner> corners = new ArrayList<Corner>();
    private int[][] image;
    private int width;
    private int height;
    private float[][] Lx2;
    private float[][] Ly2;
    private float[][] Lxy;

    public HarrisFast(int[][] image, int width, int height, IntegralImage mIntegralImage) {
        this.image = image;
        this.width = width;
        this.height = height;
    }

    private double gaussian(double x, double y, double sigma) {
        double sigma2 = sigma * sigma;
        double t = (x * x + y * y) / (2.0 * sigma2);
        double u = 1.0 / (Math.PI * 2 * sigma2);
        double e = u * Math.exp(-t);
        return e;
    }

    private float[] sobel(int x, int y) {
        int v00 = 0;
        int v01 = 0;
        int v02 = 0;
        int v10 = 0;
        int v12 = 0;
        int v20 = 0;
        int v21 = 0;
        int v22 = 0;
        int x0 = x - 1;
        int x1 = x;
        int x2 = x + 1;
        int y0 = y - 1;
        int y1 = y;
        int y2 = y + 1;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x2 >= this.width) {
            x2 = this.width - 1;
        }
        if (y2 >= this.height) {
            y2 = this.height - 1;
        }
        v00 = this.image[x0][y0];
        v10 = this.image[x1][y0];
        v20 = this.image[x2][y0];
        v01 = this.image[x0][y1];
        v21 = this.image[x2][y1];
        v02 = this.image[x0][y2];
        v12 = this.image[x1][y2];
        v22 = this.image[x2][y2];
        float sx = (float)(v20 + 2 * v21 + v22 - (v00 + 2 * v01 + v02)) / 1020.0f;
        float sy = (float)(v02 + 2 * v12 + v22 - (v00 + 2 * v10 + v20)) / 1020.0f;
        return new float[]{sx, sy};
    }

    private void computeDerivatives(double sigma) {
        this.Lx2 = new float[this.width][this.height];
        this.Ly2 = new float[this.width][this.height];
        this.Lxy = new float[this.width][this.height];
        float[][][] grad = new float[this.width][this.height][];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                grad[x][y] = this.sobel(x, y);
            }
        }
        int radius = (int)(2.0 * sigma);
        int window = 1 + 2 * radius;
        float[][] gaussian = new float[window][window];
        for (int j = -radius; j <= radius; ++j) {
            for (int i = -radius; i <= radius; ++i) {
                gaussian[i + radius][j + radius] = (float)this.gaussian(i, j, sigma);
            }
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dx = -radius; dx <= radius; ++dx) {
                        int xk = x + dx;
                        int yk = y + dy;
                        if (xk < 0 || xk >= this.width || yk < 0 || yk >= this.height) continue;
                        double gw = gaussian[dx + radius][dy + radius];
                        float[] fArray = this.Lx2[x];
                        int n = y;
                        fArray[n] = (float)((double)fArray[n] + gw * (double)grad[xk][yk][0] * (double)grad[xk][yk][0]);
                        float[] fArray2 = this.Ly2[x];
                        int n2 = y;
                        fArray2[n2] = (float)((double)fArray2[n2] + gw * (double)grad[xk][yk][1] * (double)grad[xk][yk][1]);
                        float[] fArray3 = this.Lxy[x];
                        int n3 = y;
                        fArray3[n3] = (float)((double)fArray3[n3] + gw * (double)grad[xk][yk][0] * (double)grad[xk][yk][1]);
                    }
                }
            }
        }
    }

    private float harrisMeasure(int x, int y, float k) {
        float m00 = this.Lx2[x][y];
        float m01 = this.Lxy[x][y];
        float m10 = this.Lxy[x][y];
        float m11 = this.Ly2[x][y];
        return m00 * m11 - m01 * m10 - k * (m00 + m11) * (m00 + m11);
    }

    private boolean isSpatialMaxima(float[][] hmap, int x, int y) {
        int n = 8;
        int[] dx = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
        int[] dy = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};
        double w = hmap[x][y];
        for (int i = 0; i < n; ++i) {
            double wk = hmap[x + dx[i]][y + dy[i]];
            if (!(wk >= w)) continue;
            return false;
        }
        return true;
    }

    private float[][] computeHarrisMap(double k) {
        float[][] harrismap = new float[this.width][this.height];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                double h = this.harrisMeasure(x, y, (float)k);
                if (h <= 0.0) continue;
                h = 255.0 * Math.log(1.0 + h) / Math.log(256.0);
                harrismap[x][y] = (float)h;
            }
        }
        return harrismap;
    }

    public void filter(double sigma, double k, int minDistance) {
        this.computeDerivatives(sigma);
        float[][] harrismap = this.computeHarrisMap(k);
        for (int y = 1; y < this.height - 1; ++y) {
            for (int x = 1; x < this.width - 1; ++x) {
                float h = harrismap[x][y];
                if ((double)h <= 0.001 || !this.isSpatialMaxima(harrismap, x, y)) continue;
                this.corners.add(new Corner(x, y, h));
            }
        }
        Iterator<Corner> iter = this.corners.iterator();
        block2: while (iter.hasNext()) {
            Corner p = iter.next();
            for (Corner n : this.corners) {
                int dist;
                if (n == p || (dist = (int)Math.sqrt((p.x - n.x) * (p.x - n.x) + (p.y - n.y) * (p.y - n.y))) > minDistance || n.h < p.h) continue;
                iter.remove();
                continue block2;
            }
        }
    }
}

