/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.IOUtils;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallProviderStatLogger;
import com.alibaba.druid.wall.WallProviderStatLoggerImpl;
import com.alibaba.druid.wall.WallProviderStatValue;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class WallProviderStatTimer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(WallProviderStatTimer.class);
    private ScheduledExecutorService scheduler;
    private int threadCount = 1;
    private long period = 300L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private final List<WallProvider> providers = new CopyOnWriteArrayList<WallProvider>();
    private WallProviderStatLogger statLogger = new WallProviderStatLoggerImpl();
    private static WallProviderStatTimer instance;

    public WallProviderStatTimer() {
        this.configFromPropety(System.getProperties());
    }

    public static WallProviderStatTimer getInstance() {
        return instance;
    }

    public static void setInstance(WallProviderStatTimer instance) {
        WallProviderStatTimer.instance = instance;
    }

    public void configFromPropety(Properties properties) {
        Object value = IOUtils.getLong(properties, "druid.wall.timer.period");
        if (value != null && ((Long)value).intValue() > 0) {
            this.period = ((Long)value).intValue();
        }
        if ((value = IOUtils.getInteger(properties, "druid.wall.timer.threadCount")) != null && (Integer)value > 0) {
            this.threadCount = (Integer)value;
        }
        if ((value = properties.getProperty("druid.wall.timer.statLoggerClass")) != null && ((String)value).length() > 0) {
            Class<?> clazz = IOUtils.loadClass((String)value);
            try {
                this.statLogger = (WallProviderStatLogger)clazz.newInstance();
            }
            catch (Exception ex) {
                LOG.error("configStatLogger error", ex);
            }
        }
    }

    public List<WallProvider> getProviders() {
        return this.providers;
    }

    public void register(WallProvider provider) {
        this.providers.add(provider);
    }

    public void setProviders(List<WallProvider> providers) {
        this.providers.clear();
        this.providers.addAll(providers);
    }

    public WallProviderStatLogger getStatLogger() {
        return this.statLogger;
    }

    public void setStatLogger(WallProviderStatLogger statLogger) {
        this.statLogger = statLogger;
    }

    public void start() {
        if (this.statLogger == null) {
            throw new IllegalStateException("statLogger is null");
        }
        this.scheduler = Executors.newScheduledThreadPool(this.threadCount);
        this.scheduler.scheduleAtFixedRate(this, this.period, this.period, this.unit);
    }

    @Override
    public void run() {
        for (WallProvider provider : this.providers) {
            WallProviderStatValue statValue = this.getStatValue(provider);
            this.log(statValue);
        }
    }

    protected WallProviderStatValue getStatValue(WallProvider provider) {
        return provider.getStatValue(true);
    }

    protected void log(WallProviderStatValue statValue) {
        this.statLogger.log(statValue);
    }
}

