/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitorUtils;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class ParameterizedOutputVisitor
extends SQLASTOutputVisitor
implements ParameterizedVisitor {
    private int replaceCount;

    public ParameterizedOutputVisitor() {
        this(new StringBuilder());
    }

    public ParameterizedOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public int getReplaceCount() {
        return this.replaceCount;
    }

    @Override
    public void incrementReplaceCunt() {
        ++this.replaceCount;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        x = ParameterizedOutputVisitorUtils.merge(this, x);
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }

    @Override
    public boolean visit(SQLNCharExpr x) {
        if (!ParameterizedOutputVisitorUtils.checkParameterize(x)) {
            return super.visit(x);
        }
        return ParameterizedOutputVisitorUtils.visit((ParameterizedVisitor)this, x);
    }
}

