/*
 * Decompiled with CFR 0.152.
 */
package com.aerse.mail;

import com.aerse.mail.IMailSender;
import com.aerse.mail.Log4jPrintStream;
import com.aerse.mail.MXRecord;
import com.aerse.mail.MXRecordComparator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.xml.bind.DatatypeConverter;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DirectMailSender
implements IMailSender {
    private static final Logger LOG = Logger.getLogger(DirectMailSender.class);
    private static final String[] MX_RECORD = new String[]{"MX"};
    private InitialDirContext iDirC;
    private String dkimPrivateKeyLocation;
    private String signingDomain;
    private String dkimSelector;
    private String fromEmail;
    private String fromName;
    private long connectionTimeoutMillis;
    private InternetAddress from;
    private RSAPrivateKey dkimPrivateKey;

    public void start() throws IOException, GeneralSecurityException, NamingException {
        if (this.fromEmail == null) {
            throw new IllegalStateException("from email should be specified");
        }
        if (this.dkimPrivateKeyLocation == null) {
            throw new IllegalStateException("dkim private key location should be specified");
        }
        if (this.signingDomain == null) {
            throw new IllegalStateException("signing domain should be specified");
        }
        if (this.dkimSelector == null) {
            throw new IllegalArgumentException("dkim selector should be specified");
        }
        this.iDirC = new InitialDirContext();
        this.from = new InternetAddress(this.fromEmail, this.fromName, "UTF-8");
        this.dkimPrivateKey = DirectMailSender.loadPrivateKey(this.dkimPrivateKeyLocation);
    }

    @Override
    public void send(Message mailMessage) throws MessagingException {
        List<MXRecord> mx;
        Address[] to = mailMessage.getRecipients(Message.RecipientType.TO);
        if (to == null) {
            throw new MessagingException("missing \"to\" recipients");
        }
        if (to.length > 1) {
            throw new MessagingException("only single \"to\" recipient supported");
        }
        if (!(to[0] instanceof InternetAddress)) {
            throw new MessagingException("unsupported address type: " + to[0].getClass());
        }
        InternetAddress toAddress = (InternetAddress)to[0];
        String domain = toAddress.getAddress().substring(toAddress.getAddress().indexOf(64) + 1);
        try {
            mx = this.getMX(domain);
        }
        catch (NamingException e2) {
            throw new MessagingException("unable to resolve domain: " + domain, (Exception)e2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MX records detected: " + mx));
        }
        for (int i = 0; i < mx.size(); ++i) {
            String cur = mx.get(i).getValue();
            Properties props = new Properties();
            props.setProperty("mail.smtp.host", cur);
            props.setProperty("mail.smtp.localhost", this.signingDomain);
            props.setProperty("mail.smtp.starttls.enable", "true");
            props.setProperty("mail.smtp.ssl.trust", "*");
            String timeoutMillisStr = String.valueOf(this.connectionTimeoutMillis);
            props.setProperty("mail.smtp.timeout", timeoutMillisStr);
            props.setProperty("mail.smtps.timeout", timeoutMillisStr);
            props.setProperty("mail.smtp.connectiontimeout", timeoutMillisStr);
            props.setProperty("mail.smtps.connectiontimeout", timeoutMillisStr);
            Session session = Session.getInstance((Properties)props);
            if (LOG.isDebugEnabled()) {
                try {
                    session.setDebugOut(new PrintStream((OutputStream)new Log4jPrintStream(LOG, (Priority)Level.DEBUG), false, "UTF-8"));
                    session.setDebug(true);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)this.from);
            message.setRecipient(Message.RecipientType.TO, to[0]);
            message.setSubject(mailMessage.getSubject());
            message.setReplyTo(mailMessage.getReplyTo());
            try {
                if (mailMessage.getContent() instanceof Multipart) {
                    message.setContent(mailMessage.getContent(), mailMessage.getContentType());
                } else {
                    message.setDataHandler(mailMessage.getDataHandler());
                }
            }
            catch (IOException e1) {
                throw new MessagingException("unable to get content", (Exception)e1);
            }
            message.setSentDate(new Date());
            MimeMessage dkimSignedMessage = this.dkimSignMessage(message);
            try {
                Transport.send((Message)dkimSignedMessage);
                return;
            }
            catch (MessagingException e) {
                if (!DirectMailSender.hasRootCause(e, IOException.class) || i == mx.size() - 1) {
                    throw new MessagingException("mx is not available: " + cur, (Exception)((Object)e));
                }
                LOG.info((Object)("mx is not available: " + cur));
                continue;
            }
        }
    }

    private List<MXRecord> getMX(String domainName) throws NamingException {
        Attributes attributes = this.iDirC.getAttributes("dns:/" + domainName, MX_RECORD);
        Attribute attributeMX = attributes.get("MX");
        if (attributeMX == null) {
            return Collections.singletonList(new MXRecord(0, domainName));
        }
        ArrayList<MXRecord> result = new ArrayList<MXRecord>(attributeMX.size());
        for (int i = 0; i < attributeMX.size(); ++i) {
            String curValue = attributeMX.get(i).toString();
            int spaceIndex = curValue.indexOf(32);
            if (spaceIndex == -1) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("invalid mx record: " + curValue));
                continue;
            }
            String record = curValue.charAt(curValue.length() - 1) == '.' ? curValue.substring(spaceIndex + 1, curValue.length() - 1) : curValue.substring(spaceIndex + 1);
            try {
                InetAddress[] aRecords = InetAddress.getAllByName(record);
                Integer priority = Integer.valueOf(curValue.substring(0, spaceIndex));
                for (InetAddress cur : aRecords) {
                    result.add(new MXRecord(priority, cur.getHostAddress()));
                }
                continue;
            }
            catch (UnknownHostException e) {
                String message = "unable to resolve host: " + record + " skipping";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message, (Throwable)e);
                    continue;
                }
                LOG.info((Object)message);
            }
        }
        if (result.size() > 1) {
            Collections.sort(result, MXRecordComparator.INSTANCE);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        InetAddress[] all = InetAddress.getAllByName("inmx.rambler.ru");
        System.out.println(all[0].getHostAddress());
    }

    private MimeMessage dkimSignMessage(MimeMessage message) throws MessagingException {
        DkimSigner dkimSigner = new DkimSigner(this.signingDomain, this.dkimSelector, this.dkimPrivateKey);
        dkimSigner.setIdentity(this.fromEmail);
        dkimSigner.setHeaderCanonicalization(Canonicalization.SIMPLE);
        dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
        dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
        dkimSigner.setLengthParam(true);
        dkimSigner.setZParam(false);
        dkimSigner.setCheckDomainKey(false);
        return new DkimMessage(message, dkimSigner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RSAPrivateKey loadPrivateKey(String location) throws IOException, GeneralSecurityException {
        RSAPrivateKey key = null;
        try (BufferedReader br = null;){
            InputStream is = DirectMailSender.class.getClassLoader().getResourceAsStream(location);
            if (is == null) {
                throw new IllegalArgumentException("unable to find key in classpath: " + location);
            }
            br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            boolean inKey = false;
            String line = br.readLine();
            while (line != null) {
                if (!inKey) {
                    if (line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----")) {
                        inKey = true;
                    }
                } else {
                    if (line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----")) {
                        inKey = false;
                        break;
                    }
                    builder.append(line);
                }
                line = br.readLine();
            }
            byte[] encoded = DatatypeConverter.parseBase64Binary((String)builder.toString());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            key = (RSAPrivateKey)kf.generatePrivate(keySpec);
        }
        return key;
    }

    private static boolean hasRootCause(Throwable e, Class<?> rootCause) {
        boolean result;
        if (rootCause.isInstance(e)) {
            return true;
        }
        return e.getCause() != null && (result = DirectMailSender.hasRootCause(e.getCause(), rootCause));
    }

    public void setSigningDomain(String signingDomain) {
        this.signingDomain = signingDomain;
    }

    public void setDkimPrivateKeyLocation(String dkimPrivateKeyLocation) {
        this.dkimPrivateKeyLocation = dkimPrivateKeyLocation;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public void setConnectionTimeoutMillis(long connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void setDkimSelector(String dkimSelector) {
        this.dkimSelector = dkimSelector;
    }
}

