/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.resolver.AARBasedWSDLLocator;
import org.apache.axis2.deployment.resolver.AARFileBasedURIResolver;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.WSDL2AxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;

public class ArchiveReader
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog((Class)ArchiveReader.class);

    private ArrayList buildServiceGroup(InputStream zin, DeploymentEngine engine, AxisServiceGroup axisServiceGroup, HashMap wsdlServices, AxisConfiguration axisConfig) throws XMLStreamException, AxisFault {
        DescriptionBuilder builder = new DescriptionBuilder(zin, axisConfig);
        OMElement rootElement = builder.buildOM();
        String elementName = rootElement.getLocalName();
        if ("service".equals(elementName)) {
            AxisService axisService = null;
            String serviceName = DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getName());
            if (serviceName != null) {
                axisService = (AxisService)wsdlServices.get(serviceName);
            }
            if (axisService == null) {
                axisService = (AxisService)wsdlServices.get(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getName()));
            }
            if (axisService == null) {
                axisService = new AxisService(serviceName);
            } else {
                axisService.setWsdlfound(true);
            }
            axisService.setParent(axisServiceGroup);
            axisService.setClassLoader(engine.getCurrentFileItem().getClassLoader());
            ServiceBuilder serviceBuilder = new ServiceBuilder(axisConfig, axisService);
            AxisService service = serviceBuilder.populateService(rootElement);
            ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
            serviceList.add(service);
            return serviceList;
        }
        if ("serviceGroup".equals(elementName)) {
            ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, wsdlServices, axisConfig);
            return groupBuilder.populateServiceGroup(axisServiceGroup);
        }
        throw new AxisFault("In valid services.xml found");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList processServiceGroup(String filename, DeploymentEngine engine, AxisServiceGroup axisServiceGroup, boolean extractService, HashMap wsdls, AxisConfiguration axisConfig) throws AxisFault {
        if (!extractService) {
            zin = null;
            try {
                try {
                    zin = new ZipInputStream(new FileInputStream(filename));
                    do {
                        if ((entry = zin.getNextEntry()) == null) throw new DeploymentException(Messages.getMessage("servicexmlnotfound", filename));
                    } while (!entry.getName().equalsIgnoreCase("META-INF/services.xml"));
                    axisServiceGroup.setServiceGroupName(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getName()));
                    var9_12 = this.buildServiceGroup(zin, engine, axisServiceGroup, wsdls, axisConfig);
                    var11_16 = null;
                    if (zin == null) return var9_12;
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            catch (Throwable var10_20) {
                var11_17 = null;
                if (zin == null) throw var10_20;
                try {
                    zin.close();
                    throw var10_20;
                }
                catch (IOException e) {
                    ArchiveReader.log.info((Object)Messages.getMessage("errorininputstreamclose"));
                }
                throw var10_20;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 124->132)] { 
lbl29:
            // 1 sources

            zin.close();
            return var9_12;
lbl31:
            // 1 sources

            catch (IOException e) {
                ArchiveReader.log.info((Object)Messages.getMessage("errorininputstreamclose"));
            }
            return var9_12;
        }
        file = new File(filename, "META-INF/services.xml");
        if (!file.exists()) {
            file = new File(filename, "META-INF/services.xml".toLowerCase());
        }
        if (file.exists() == false) throw new DeploymentException(Messages.getMessage("servicexmlnotfound"));
        in = null;
        try {
            try {
                in = new FileInputStream(file);
                axisServiceGroup.setServiceGroupName(engine.getCurrentFileItem().getName());
                var9_13 = this.buildServiceGroup(in, engine, axisServiceGroup, wsdls, axisConfig);
                var14_21 = null;
                if (in == null) return var9_13;
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(Messages.getMessage("StreamException", e.getMessage()));
            }
        }
        catch (Throwable var13_25) {
            var14_22 = null;
            if (in == null) throw var13_25;
            try {
                in.close();
                throw var13_25;
            }
            catch (IOException e) {
                ArchiveReader.log.info((Object)Messages.getMessage("errorininputstreamclose"));
            }
            throw var13_25;
        }
        try {}
        catch (IOException e) {
            ArchiveReader.log.info((Object)Messages.getMessage("errorininputstreamclose"));
            return var9_13;
        }
        in.close();
        return var9_13;
    }

    private AxisService processWSDLFile(InputStream in, File serviceArchiveFile, boolean isArchive) throws DeploymentException {
        try {
            WSDL2AxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL2AxisServiceBuilder(in, null, null);
            if (serviceArchiveFile != null && isArchive) {
                wsdl2AxisServiceBuilder.setCustomResolver((URIResolver)new AARFileBasedURIResolver(serviceArchiveFile));
                wsdl2AxisServiceBuilder.setCustomWSLD4JResolver(new AARBasedWSDLLocator(serviceArchiveFile, in));
            } else if (serviceArchiveFile != null) {
                wsdl2AxisServiceBuilder.setBaseUri(serviceArchiveFile.getParentFile().getAbsolutePath());
            }
            return wsdl2AxisServiceBuilder.populateService();
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    public HashMap processWSDLs(ArchiveFileData file, DeploymentEngine depengine) throws DeploymentException {
        File serviceFile = file.getFile();
        HashMap<String, AxisService> servicesMap = new HashMap<String, AxisService>();
        boolean isDirectory = serviceFile.isDirectory();
        if (isDirectory) {
            try {
                File meta_inf = new File(serviceFile, "META-INF");
                if (!meta_inf.exists()) {
                    throw new DeploymentException(Messages.getMessage("noMetaInf", serviceFile.getName()));
                }
                File[] files = meta_inf.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file1 = files[i];
                    if (!file1.getName().toLowerCase().endsWith(".wsdl")) continue;
                    FileInputStream in = new FileInputStream(file1);
                    AxisService service = this.processWSDLFile(in, file1, false);
                    servicesMap.put(service.getName(), service);
                    try {
                        ((InputStream)in).close();
                        continue;
                    }
                    catch (IOException e) {
                        log.info((Object)e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(e);
            }
            catch (IOException e) {
                throw new DeploymentException(e);
            }
        }
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(serviceFile));
            byte[] buf = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                int read;
                String entryName = entry.getName().toLowerCase();
                if (!entryName.startsWith("META-INF".toLowerCase()) || !entryName.endsWith(".wsdl")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((read = zin.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                AxisService service = this.processWSDLFile(in, serviceFile, true);
                servicesMap.put(service.getName(), service);
            }
            try {
                zin.close();
            }
            catch (IOException e) {
                log.info((Object)e);
            }
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        return servicesMap;
    }

    public void readModuleArchive(String filename, DeploymentEngine engine, AxisModule module, boolean explodedDir, AxisConfiguration axisConfig) throws DeploymentException {
        block9: {
            boolean foundmoduleXML = false;
            if (!explodedDir) {
                try {
                    ZipEntry entry;
                    ZipInputStream zin = new ZipInputStream(new FileInputStream(filename));
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().equalsIgnoreCase("META-INF/module.xml")) continue;
                        foundmoduleXML = true;
                        ModuleBuilder builder = new ModuleBuilder(zin, module, axisConfig);
                        module.setName(new QName(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getServiceName())));
                        builder.populateModule();
                        break;
                    }
                    zin.close();
                    if (!foundmoduleXML) {
                        throw new DeploymentException(Messages.getMessage("modulexmlnotfound", filename));
                    }
                    break block9;
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            File file = new File(filename, "META-INF/module.xml");
            if (file.exists() || (file = new File(filename, "META-INF/module.xml".toLowerCase())).exists()) {
                try {
                    FileInputStream in = new FileInputStream(file);
                    ModuleBuilder builder = new ModuleBuilder(in, module, axisConfig);
                    module.setName(new QName(DescriptionBuilder.getShortFileName(engine.getCurrentFileItem().getServiceName())));
                    builder.populateModule();
                }
                catch (FileNotFoundException e) {
                    throw new DeploymentException(Messages.getMessage("fileNotFound", e.getMessage()));
                }
            } else {
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", filename));
            }
        }
    }
}

