/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceBuilder
extends DescriptionBuilder {
    private static final Log log = LogFactory.getLog((Class)ServiceBuilder.class);
    private AxisService service;

    public ServiceBuilder(AxisConfiguration axisConfig, AxisService service) {
        this.service = service;
        this.axisConfig = axisConfig;
    }

    public ServiceBuilder(InputStream serviceInputStream, AxisConfiguration axisConfig, AxisService service) {
        super(serviceInputStream, axisConfig);
        this.service = service;
    }

    public AxisService populateService(OMElement service_element) throws DeploymentException {
        try {
            int i;
            String sessionScope;
            Iterator policyRefElements;
            Iterator policyElements;
            OMElement messageReceiver;
            String nameSpeceVale;
            OMAttribute schemaNameSpace;
            Iterator itr = service_element.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.service, this.service.getParent());
            OMElement descriptionElement = service_element.getFirstChildWithName(new QName("description"));
            if (descriptionElement != null) {
                OMElement descriptionValue = descriptionElement.getFirstElement();
                if (descriptionValue != null) {
                    StringWriter writer = new StringWriter();
                    descriptionValue.build();
                    descriptionValue.serialize((Writer)writer);
                    writer.flush();
                    this.service.setServiceDescription(writer.toString());
                } else {
                    this.service.setServiceDescription(descriptionElement.getText());
                }
            } else {
                OMAttribute serviceNameatt = service_element.getAttribute(new QName("name"));
                if (serviceNameatt != null) {
                    this.service.setServiceDescription(serviceNameatt.getAttributeValue());
                }
            }
            OMAttribute targetNameSpace = service_element.getAttribute(new QName("targetNamespace"));
            if (targetNameSpace != null) {
                String nameSpeceVale2 = targetNameSpace.getAttributeValue();
                if (nameSpeceVale2 != null && !"".equals(nameSpeceVale2)) {
                    this.service.setTargetNamespace(nameSpeceVale2);
                }
            } else if (this.service.getTargetNamespace() == null || "".equals(this.service.getTargetNamespace())) {
                this.service.setTargetNamespace("http://ws.apache.org/axis2");
            }
            OMElement scheamElement = service_element.getFirstChildWithName(new QName("schema"));
            if (scheamElement != null && (schemaNameSpace = scheamElement.getAttribute(new QName("schemaNamespace"))) != null && (nameSpeceVale = schemaNameSpace.getAttributeValue()) != null && !"".equals(nameSpeceVale)) {
                this.service.setSchematargetNamespace(nameSpeceVale);
            }
            if ((messageReceiver = service_element.getFirstChildWithName(new QName("messageReceivers"))) != null) {
                HashMap mrs = this.processMessageReceivers(this.service.getClassLoader(), messageReceiver);
                Iterator keys = mrs.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.service.addMessageReceiver(key, (MessageReceiver)mrs.get(key));
                }
            }
            OMElement excludeOperations = service_element.getFirstChildWithName(new QName("excludeOperations"));
            ArrayList<String> excludeops = null;
            if (excludeOperations != null) {
                excludeops = this.processExcludeOperations(excludeOperations);
            }
            if (excludeops == null) {
                excludeops = new ArrayList<String>();
            }
            excludeops.add("init");
            excludeops.add("setOperationContext");
            excludeops.add("destroy");
            if (!this.service.isWsdlfound()) {
                try {
                    Utils.fillAxisService(this.service, this.axisConfig, excludeops);
                }
                catch (Exception e) {
                    log.error((Object)Messages.getMessage("errorinscheamgen", e.getMessage()), (Throwable)e);
                }
            }
            if ((policyElements = service_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"))) != null) {
                this.processPolicyElements(3, policyElements, this.service.getPolicyInclude());
            }
            if ((policyRefElements = service_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(3, policyRefElements, this.service.getPolicyInclude());
            }
            if ((sessionScope = service_element.getAttributeValue(new QName("scope"))) != null) {
                this.service.setScope(sessionScope);
            }
            Iterator moduleRefs = service_element.getChildrenWithName(new QName("module"));
            this.processModuleRefs(moduleRefs);
            OMElement transports = service_element.getFirstChildWithName(new QName("transports"));
            if (transports != null) {
                Iterator transport_itr = transports.getChildrenWithName(new QName("transport"));
                ArrayList<String> trs = new ArrayList<String>();
                while (transport_itr.hasNext()) {
                    OMElement trsEle = (OMElement)transport_itr.next();
                    trs.add(trsEle.getText());
                }
                this.service.setExposeTransports(trs.toArray(new String[trs.size()]));
            }
            Iterator operationsIterator = service_element.getChildrenWithName(new QName("operation"));
            ArrayList ops = this.processOperations(operationsIterator);
            for (i = 0; i < ops.size(); ++i) {
                AxisOperation operationDesc = (AxisOperation)ops.get(i);
                ArrayList wsamappings = operationDesc.getWsamappingList();
                if (wsamappings == null) continue;
                for (int j = 0; j < wsamappings.size(); ++j) {
                    String mapping = (String)wsamappings.get(j);
                    this.service.mapActionToOperation(mapping, operationDesc);
                }
                if (this.service.getOperation(operationDesc.getName()) != null) continue;
                this.service.addOperation(operationDesc);
            }
            for (i = 0; i < excludeops.size(); ++i) {
                String opName = (String)excludeops.get(i);
                this.service.removeOperation(new QName(opName));
            }
            Iterator operations = this.service.getPublishedOperations().iterator();
            while (operations.hasNext()) {
                AxisOperation operation = (AxisOperation)operations.next();
                if (operation.getMessageReceiver() != null) continue;
                operation.setMessageReceiver(this.loadDefaultMessageReceiver(operation.getMessageExchangePattern(), this.service));
            }
            Iterator moduleConfigs = service_element.getChildrenWithName(new QName("moduleConfig"));
            this.processServiceModuleConfig(moduleConfigs, this.service, this.service);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(Messages.getMessage("op_error", axisFault.getMessage()));
        }
        return this.service;
    }

    private ArrayList processExcludeOperations(OMElement exculeOperations) {
        ArrayList<String> exOps = new ArrayList<String>();
        Iterator excludeOp_itr = exculeOperations.getChildrenWithName(new QName("operation"));
        while (excludeOp_itr.hasNext()) {
            OMElement opName = (OMElement)excludeOp_itr.next();
            exOps.add(opName.getText().trim());
        }
        return exOps;
    }

    private void processMessages(Iterator messages, AxisOperation operation) throws DeploymentException {
        while (messages.hasNext()) {
            Iterator policyRefElements;
            OMElement messageElement = (OMElement)messages.next();
            OMAttribute lable = messageElement.getAttribute(new QName("label"));
            if (lable == null) {
                throw new DeploymentException(Messages.getMessage("messagelabelcannotfound"));
            }
            AxisMessage message = operation.getMessage(lable.getAttributeValue());
            Iterator parameters = messageElement.getChildrenWithName(new QName("parameter"));
            Iterator policyElements = messageElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null) {
                this.processPolicyElements(5, policyElements, message.getPolicyInclude());
            }
            if ((policyRefElements = messageElement.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(5, policyRefElements, message.getPolicyInclude());
            }
            this.processParameters(parameters, message, operation);
        }
    }

    protected void processModuleRefs(Iterator moduleRefs) throws DeploymentException {
        try {
            while (moduleRefs.hasNext()) {
                OMElement moduleref = (OMElement)moduleRefs.next();
                OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
                if (moduleRefAttribute == null) continue;
                String refName = moduleRefAttribute.getAttributeValue();
                if (this.axisConfig.getModule(new QName(refName)) == null) {
                    throw new DeploymentException(Messages.getMessage("modulenotfound", refName));
                }
                this.service.addModuleref(new QName(refName));
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    protected void processOperationModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisOperation operation) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(new QName(module), parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            operation.addModuleConfig(moduleConfiguration);
        }
    }

    private ArrayList processOperations(Iterator operationsIterator) throws AxisFault {
        ArrayList<AxisOperation> operations = new ArrayList<AxisOperation>();
        while (operationsIterator.hasNext()) {
            OMElement receiverElement;
            Iterator policyRefElements;
            Iterator policyElements;
            String opname;
            AxisOperation op_descrip;
            OMElement operation = (OMElement)operationsIterator.next();
            OMAttribute op_name_att = operation.getAttribute(new QName("name"));
            if (op_name_att == null) {
                throw new DeploymentException(Messages.getMessage(Messages.getMessage("invalid_op", "operation name missing")));
            }
            OMAttribute op_mep_att = operation.getAttribute(new QName("mep"));
            String mepurl = null;
            if (op_mep_att != null) {
                mepurl = op_mep_att.getAttributeValue();
            }
            if ((op_descrip = this.service.getOperation(new QName(opname = op_name_att.getAttributeValue()))) == null) {
                AxisMessage outAxisMessage;
                AxisMessage inaxisMessage;
                if (mepurl == null) {
                    op_descrip = new InOutAxisOperation();
                    op_descrip.setParent(this.service);
                } else {
                    op_descrip = AxisOperationFactory.getOperationDescription(mepurl);
                }
                op_descrip.setName(new QName(opname));
                String MEP = op_descrip.getMessageExchangePattern();
                if (("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (inaxisMessage = op_descrip.getMessage("In")) != null) {
                    inaxisMessage.setName(opname + "Message");
                }
                if (("http://www.w3.org/2004/08/wsdl/out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/2004/08/wsdl/in-out".equals(MEP)) && (outAxisMessage = op_descrip.getMessage("Out")) != null) {
                    outAxisMessage.setName(opname + "Response");
                }
            }
            if ((policyElements = operation.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"))) != null) {
                this.processPolicyElements(4, policyElements, op_descrip.getPolicyInclude());
            }
            if ((policyRefElements = operation.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(4, policyRefElements, op_descrip.getPolicyInclude());
            }
            Iterator parameters = operation.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, op_descrip, this.service);
            Iterator mappingIterator = operation.getChildrenWithName(new QName("actionMapping"));
            if (mappingIterator != null) {
                ArrayList wsamappings = this.processWsaMapping(mappingIterator);
                op_descrip.setWsamappingList(wsamappings);
            }
            if ((receiverElement = operation.getFirstChildWithName(new QName("messageReceiver"))) != null) {
                MessageReceiver messageReceiver = this.loadMessageReceiver(this.service.getClassLoader(), receiverElement);
                op_descrip.setMessageReceiver(messageReceiver);
            } else {
                MessageReceiver msgReceiver = this.loadDefaultMessageReceiver(op_descrip.getMessageExchangePattern(), this.service);
                op_descrip.setMessageReceiver(msgReceiver);
            }
            Iterator modules = operation.getChildrenWithName(new QName("module"));
            this.processOperationModuleRefs(modules, op_descrip);
            Iterator messages = operation.getChildrenWithName(new QName("message"));
            this.processMessages(messages, op_descrip);
            if (this.axisConfig != null) {
                PhasesInfo info = this.axisConfig.getPhasesInfo();
                info.setOperationPhases(op_descrip);
            }
            Iterator moduleConfigs = operation.getChildrenWithName(new QName("moduleConfig"));
            this.processOperationModuleConfig(moduleConfigs, op_descrip, op_descrip);
            operations.add(op_descrip);
        }
        return operations;
    }

    protected void processServiceModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisService service) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(new QName(module), parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            service.addModuleConfig(moduleConfiguration);
        }
    }
}

