/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.udp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.udp.IoSessionInputStream;
import org.apache.cxf.transport.udp.UDPDestination;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.NioDatagramConnector;

public class UDPConduit
extends AbstractConduit {
    private static final String CXF_MESSAGE_ATTR = "CXFMessage";
    private static final String MULTI_RESPONSE_TIMEOUT = "udp.multi.response.timeout";
    private static final String HOST_PORT = UDPConduit.class + ".host:port";
    private static final Logger LOG = LogUtils.getL7dLogger(UDPDestination.class);
    Bus bus;
    NioDatagramConnector connector = new NioDatagramConnector();
    ConcurrentHashMap<String, Queue<ConnectFuture>> connections = new ConcurrentHashMap();

    public UDPConduit(EndpointReferenceType t, Bus bus) {
        super(t);
        this.bus = bus;
        this.connector.getSessionConfig().setReadBufferSize(65536);
        this.connector.getSessionConfig().setSendBufferSize(65536);
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object buf) {
                Message message = (Message)session.getAttribute((Object)UDPConduit.CXF_MESSAGE_ATTR);
                UDPConduit.this.dataReceived(message, (IoBuffer)buf, true);
            }
        });
    }

    private void dataReceived(Message message, IoBuffer buf, boolean async) {
        if (message.getExchange().getInMessage() == null) {
            final MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(message.getExchange());
            message.getExchange().setInMessage(inMessage);
            IoSessionInputStream ins = new IoSessionInputStream(buf);
            inMessage.setContent(InputStream.class, ins);
            inMessage.put(IoSessionInputStream.class, ins);
            if (async) {
                WorkQueueManager queuem = this.bus.getExtension(WorkQueueManager.class);
                AutomaticWorkQueue queue = queuem.getNamedWorkQueue("udp-conduit");
                if (queue == null) {
                    queue = queuem.getAutomaticWorkQueue();
                }
                queue.execute(new Runnable(){

                    @Override
                    public void run() {
                        UDPConduit.this.incomingObserver.onMessage(inMessage);
                    }
                });
            } else {
                this.incomingObserver.onMessage(inMessage);
                if (!message.getExchange().isSynchronous()) {
                    message.getExchange().setInMessage(null);
                }
            }
        } else {
            IoSessionInputStream ins = message.getExchange().getInMessage().get(IoSessionInputStream.class);
            ins.setBuffer(buf);
        }
    }

    @Override
    public void close(Message msg) throws IOException {
        super.close(msg);
        if (msg.getExchange().isOneWay() || msg.getExchange().getInMessage() == msg || msg.getExchange().getInFaultMessage() == msg) {
            String s = (String)msg.getExchange().get(HOST_PORT);
            ConnectFuture c = msg.getExchange().get(ConnectFuture.class);
            if (s != null && c != null) {
                c.getSession().removeAttribute((Object)CXF_MESSAGE_ATTR);
                Queue<ConnectFuture> q = this.connections.get(s);
                if (q == null) {
                    this.connections.putIfAbsent(s, new ArrayBlockingQueue(10));
                    q = this.connections.get(s);
                }
                if (!q.offer(c)) {
                    c.getSession().close(false);
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
        for (Queue<ConnectFuture> f : this.connections.values()) {
            for (ConnectFuture cf : f) {
                cf.getSession().close(false);
            }
        }
        this.connections.clear();
        this.connector.dispose();
        this.connector = null;
    }

    @Override
    public void prepare(Message message) throws IOException {
        try {
            URI uri;
            String address = (String)message.get(Message.ENDPOINT_ADDRESS);
            if (StringUtils.isEmpty(address)) {
                address = this.getTarget().getAddress().getValue();
            }
            if (StringUtils.isEmpty((uri = new URI(address)).getHost())) {
                String s = uri.getSchemeSpecificPart();
                if (s.startsWith("//:")) {
                    s = s.substring(3);
                }
                if (s.indexOf(47) != -1) {
                    s = s.substring(0, s.indexOf(47));
                }
                int port = Integer.parseInt(s);
                this.sendViaBroadcast(message, null, port);
            } else {
                InetSocketAddress isa = null;
                String hp = "";
                isa = new InetSocketAddress(uri.getHost(), uri.getPort());
                hp = uri.getHost() + ":" + uri.getPort();
                if (isa.getAddress().isMulticastAddress()) {
                    this.sendViaBroadcast(message, isa, isa.getPort());
                    return;
                }
                Queue<ConnectFuture> q = this.connections.get(hp);
                ConnectFuture connFuture = null;
                if (q != null) {
                    connFuture = q.poll();
                }
                if (connFuture == null) {
                    connFuture = this.connector.connect((SocketAddress)isa);
                    connFuture.await();
                    ((DatagramSessionConfig)connFuture.getSession().getConfig()).setSendBufferSize(65536);
                    ((DatagramSessionConfig)connFuture.getSession().getConfig()).setReceiveBufferSize(65536);
                }
                connFuture.getSession().setAttribute((Object)CXF_MESSAGE_ATTR, (Object)message);
                message.setContent(OutputStream.class, new UDPConduitOutputStream(this.connector, connFuture, message));
                message.getExchange().put(ConnectFuture.class, connFuture);
                message.getExchange().put(HOST_PORT, uri.getHost() + ":" + uri.getPort());
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void sendViaBroadcast(Message message, InetSocketAddress isa, int port) {
        message.setContent(OutputStream.class, new UDPBroadcastOutputStream(port, isa, message));
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public class UDPConduitOutputStream
    extends OutputStream {
        final ConnectFuture future;
        final NioDatagramConnector connector;
        final Message message;
        IoBuffer buffer = IoBuffer.allocate((int)65494);
        boolean closed;

        public UDPConduitOutputStream(NioDatagramConnector connector, ConnectFuture connFuture, Message m) {
            this.connector = connector;
            this.future = connFuture;
            this.message = m;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.put(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > this.buffer.remaining()) {
                int nlen = this.buffer.remaining();
                this.buffer.put(b, off, nlen);
                len -= nlen;
                off += nlen;
                this.send();
                this.buffer = IoBuffer.allocate((int)65494);
            }
            this.buffer.put(b, off, len);
        }

        private void send() throws IOException {
            try {
                this.future.await();
            }
            catch (InterruptedException e) {
                if (this.future.getException() != null) {
                    throw new IOException(this.future.getException());
                }
                throw new IOException(e);
            }
            if (this.future.getException() != null) {
                throw new IOException(this.future.getException());
            }
            this.buffer.flip();
            this.future.getSession().write((Object)this.buffer);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.send();
        }
    }

    private final class UDPBroadcastOutputStream
    extends LoadingByteArrayOutputStream {
        private final int port;
        private final Message message;
        private final InetSocketAddress multicast;

        private UDPBroadcastOutputStream(int port, InetSocketAddress isa, Message message) {
            this.port = port;
            this.message = message;
            this.multicast = isa;
        }

        @Override
        public void close() throws IOException {
            DatagramSocket socket;
            block17: {
                super.close();
                socket = this.multicast != null ? new MulticastSocket(null) : new DatagramSocket();
                socket.setSendBufferSize(this.size());
                socket.setReceiveBufferSize(65536);
                socket.setBroadcast(true);
                if (this.multicast == null) {
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface networkInterface = interfaces.nextElement();
                        if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                        for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                            InetAddress broadcast = interfaceAddress.getBroadcast();
                            if (broadcast == null) continue;
                            DatagramPacket sendPacket = new DatagramPacket(this.getRawBytes(), 0, this.size(), broadcast, this.port);
                            try {
                                socket.send(sendPacket);
                            }
                            catch (Exception e) {}
                        }
                    }
                } else {
                    DatagramPacket sendPacket = new DatagramPacket(this.getRawBytes(), 0, this.size(), this.multicast);
                    try {
                        socket.send(sendPacket);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!this.message.getExchange().isOneWay()) {
                    byte[] bytes = new byte[65536];
                    DatagramPacket p = new DatagramPacket(bytes, bytes.length);
                    Object to = this.message.getContextualProperty(UDPConduit.MULTI_RESPONSE_TIMEOUT);
                    Integer i = null;
                    if (to instanceof String) {
                        i = Integer.parseInt((String)to);
                    } else if (to instanceof Integer) {
                        i = (Integer)to;
                    }
                    if (i == null || i <= 0 || this.message.getExchange().isSynchronous()) {
                        socket.setSoTimeout(30000);
                        socket.receive(p);
                        UDPConduit.this.dataReceived(this.message, IoBuffer.wrap((byte[])bytes, (int)0, (int)p.getLength()), false);
                    } else {
                        socket.setSoTimeout(i);
                        boolean found = false;
                        try {
                            while (true) {
                                socket.receive(p);
                                UDPConduit.this.dataReceived(this.message, IoBuffer.wrap((byte[])bytes, (int)0, (int)p.getLength()), false);
                                found = true;
                            }
                        }
                        catch (SocketTimeoutException ex) {
                            if (found) break block17;
                            throw ex;
                        }
                    }
                }
            }
            socket.close();
        }

        @Override
        public void flush() throws IOException {
        }
    }
}

