/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.AbstractObservable;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;

public class DestinationRegistryImpl
implements DestinationRegistry {
    private static final String SLASH = "/";
    private ConcurrentMap<String, AbstractHTTPDestination> destinations = new ConcurrentHashMap<String, AbstractHTTPDestination>();
    private Map<String, AbstractHTTPDestination> decodedDestinations = new ConcurrentHashMap<String, AbstractHTTPDestination>();

    @Override
    public void addDestination(AbstractHTTPDestination destination) {
        String path = DestinationRegistryImpl.getTrimmedPath(destination.getEndpointInfo().getAddress());
        this.destinations.putIfAbsent(path, destination);
        try {
            this.decodedDestinations.put(URLDecoder.decode(path, "ISO-8859-1"), destination);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported Encoding", e);
        }
    }

    @Override
    public void removeDestination(String path) {
        this.destinations.remove(path);
        try {
            this.decodedDestinations.remove(URLDecoder.decode(path, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported Encoding", e);
        }
    }

    @Override
    public AbstractHTTPDestination getDestinationForPath(String path) {
        return this.getDestinationForPath(path, false);
    }

    @Override
    public AbstractHTTPDestination getDestinationForPath(String path, boolean tryDecoding) {
        String m = DestinationRegistryImpl.getTrimmedPath(path);
        AbstractHTTPDestination s = (AbstractHTTPDestination)this.destinations.get(m);
        if (s == null) {
            s = this.decodedDestinations.get(m);
        }
        return s;
    }

    @Override
    public AbstractHTTPDestination checkRestfulRequest(String address) {
        int len = -1;
        AbstractObservable ret = null;
        for (String path : this.getDestinationsPaths()) {
            String thePath;
            String string = thePath = path.length() > 1 && path.endsWith(SLASH) ? path.substring(0, path.length() - 1) : path;
            if (!address.equals(thePath) && !SLASH.equals(thePath) && (address.length() <= thePath.length() || !address.startsWith(thePath) || address.charAt(thePath.length()) != '/') || thePath.length() <= len) continue;
            ret = this.getDestinationForPath(path);
            len = path.length();
        }
        if (ret != null && ret.getMessageObserver() == null) {
            return null;
        }
        return ret;
    }

    @Override
    public Collection<AbstractHTTPDestination> getDestinations() {
        return Collections.unmodifiableCollection(this.destinations.values());
    }

    @Override
    public AbstractDestination[] getSortedDestinations() {
        LinkedList<AbstractHTTPDestination> dest2 = new LinkedList<AbstractHTTPDestination>(this.getDestinations());
        Collections.sort(dest2, new Comparator<AbstractHTTPDestination>(){

            @Override
            public int compare(AbstractHTTPDestination o1, AbstractHTTPDestination o2) {
                if (o1.getEndpointInfo().getInterface() == null) {
                    return -1;
                }
                if (o2.getEndpointInfo().getInterface() == null) {
                    return 1;
                }
                return o1.getEndpointInfo().getInterface().getName().getLocalPart().compareTo(o2.getEndpointInfo().getInterface().getName().getLocalPart());
            }
        });
        return dest2.toArray(new AbstractDestination[dest2.size()]);
    }

    @Override
    public Set<String> getDestinationsPaths() {
        return Collections.unmodifiableSet(this.destinations.keySet());
    }

    public static String getTrimmedPath(String path) {
        if (path == null) {
            return SLASH;
        }
        String lh = "http://localhost/";
        String lhs = "https://localhost/";
        if (path.startsWith("http://localhost/")) {
            path = path.substring("http://localhost/".length());
        } else if (path.startsWith("https://localhost/")) {
            path = path.substring("https://localhost/".length());
        }
        if (!path.contains("://") && !path.startsWith(SLASH)) {
            path = SLASH + path;
        }
        return path;
    }
}

