/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.Tag;

public final class ToolsStaxUtils {
    private ToolsStaxUtils() {
    }

    public static List<Tag> getTags(File source) throws Exception {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        List<String> ignoreEmptyTags = Arrays.asList("sequence");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(is);
        Tag newTag = null;
        int count = 0;
        QName checkingPoint = null;
        Stack<Tag> stack = new Stack<Tag>();
        while (reader.hasNext()) {
            int event = reader.next();
            if (checkingPoint != null) {
                ++count;
            }
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader.getName());
                if (ignoreEmptyTags.contains(reader.getLocalName())) {
                    checkingPoint = reader.getName();
                }
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    newTag.getAttributes().put(reader.getAttributeName(i), reader.getAttributeValue(i));
                }
                stack.push(newTag);
            }
            if (event == 4) {
                newTag.setText(reader.getText());
            }
            if (event != 2) continue;
            Tag startTag = (Tag)stack.pop();
            if (checkingPoint != null && checkingPoint.equals(reader.getName())) {
                if (count != 1) {
                    tags.add(startTag);
                }
                count = 0;
                checkingPoint = null;
                continue;
            }
            tags.add(startTag);
        }
        reader.close();
        return tags;
    }

    public static Tag getTagTree(File source) throws Exception {
        return ToolsStaxUtils.getTagTree(source, new ArrayList<String>());
    }

    public static Tag getTagTree(File source, List<String> ignoreAttr) throws Exception {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        return ToolsStaxUtils.getTagTree(is, ignoreAttr);
    }

    public static Tag getTagTree(InputStream is, List<String> ignoreAttr) throws Exception {
        Tag root = new Tag();
        root.setName(new QName("root", "root"));
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(is);
        Tag newTag = null;
        Tag currentTag = root;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                newTag = new Tag();
                newTag.setName(reader.getName());
                if (!ignoreAttr.isEmpty()) {
                    newTag.getIgnoreAttr().addAll(ignoreAttr);
                }
                for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    if ("type".equals(reader.getAttributeLocalName(i)) && "element".equals(reader.getLocalName())) {
                        String tp = reader.getAttributeValue(i);
                        if (tp.contains(":")) {
                            String ns = tp.substring(0, tp.indexOf(":"));
                            if ("tns".equals(ns)) {
                                tp = tp.substring(tp.indexOf(":") + 1);
                            } else {
                                ns = reader.getNamespaceURI(ns);
                                tp = "{" + ns + "}" + tp.substring(tp.indexOf(":") + 1);
                            }
                        }
                        newTag.getAttributes().put(reader.getAttributeName(i), tp);
                        continue;
                    }
                    newTag.getAttributes().put(reader.getAttributeName(i), reader.getAttributeValue(i));
                }
                newTag.setParent(currentTag);
                currentTag.getTags().add(newTag);
                currentTag = newTag;
            }
            if (event == 4) {
                newTag.setText(reader.getText());
            }
            if (event != 2) continue;
            currentTag = currentTag.getParent();
        }
        reader.close();
        return root;
    }

    public Tag getLastTag(Tag tag) {
        int lastIndex = tag.getTags().size() - 1;
        return tag.getTags().get(lastIndex);
    }
}

