/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.owner;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.owner.ResourceOwnerLoginHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class ResourceOwnerGrantHandler
extends AbstractGrantHandler {
    private ResourceOwnerLoginHandler loginHandler;

    public ResourceOwnerGrantHandler() {
        super("password", true);
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        this.checkIfGrantSupported(client);
        String ownerName = (String)params.getFirst((Object)"username");
        String ownerPassword = (String)params.getFirst((Object)"password");
        if (ownerName == null || ownerPassword == null) {
            throw new OAuthServiceException("invalid_request");
        }
        UserSubject subject = null;
        try {
            subject = this.loginHandler.createSubject(ownerName, ownerPassword);
        }
        catch (Exception ex) {
            throw new OAuthServiceException("invalid_request");
        }
        return this.doCreateAccessToken(client, subject, OAuthUtils.parseScope((String)params.getFirst((Object)"scope")));
    }

    public void setLoginHandler(ResourceOwnerLoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }
}

