/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.io.CachedWriterCallback;

public class CachedWriter
extends Writer {
    private static final File DEFAULT_TEMP_DIR;
    private static int defaultThreshold;
    private static long defaultMaxSize;
    protected boolean outputLocked;
    protected Writer currentStream;
    private long threshold = defaultThreshold;
    private long maxSize = defaultMaxSize;
    private long totalLength;
    private boolean inmem = true;
    private boolean tempFileFailed;
    private File tempFile;
    private File outputDir = DEFAULT_TEMP_DIR;
    private boolean allowDeleteOfFile = true;
    private List<CachedWriterCallback> callbacks;
    private List<Object> streamList = new ArrayList<Object>();

    public CachedWriter() {
        this.currentStream = new LoadingCharArrayWriter();
    }

    public CachedWriter(long threshold) {
        this();
        this.threshold = threshold;
    }

    public void holdTempFile() {
        this.allowDeleteOfFile = false;
    }

    public void releaseTempFileHold() {
        this.allowDeleteOfFile = true;
    }

    public void registerCallback(CachedWriterCallback cb) {
        if (null == this.callbacks) {
            this.callbacks = new ArrayList<CachedWriterCallback>();
        }
        this.callbacks.add(cb);
    }

    public void deregisterCallback(CachedWriterCallback cb) {
        if (null != this.callbacks) {
            this.callbacks.remove(cb);
        }
    }

    public List<CachedWriterCallback> getCallbacks() {
        return this.callbacks == null ? null : Collections.unmodifiableList(this.callbacks);
    }

    protected void doFlush() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
        if (null != this.callbacks) {
            for (CachedWriterCallback cb : this.callbacks) {
                cb.onFlush(this);
            }
        }
        this.doFlush();
    }

    protected void doClose() throws IOException {
    }

    protected void postClose() throws IOException {
    }

    public void lockOutputStream() throws IOException {
        if (this.outputLocked) {
            return;
        }
        this.currentStream.flush();
        this.outputLocked = true;
        if (null != this.callbacks) {
            for (CachedWriterCallback cb : this.callbacks) {
                cb.onClose(this);
            }
        }
        this.doClose();
        this.streamList.remove(this.currentStream);
    }

    @Override
    public void close() throws IOException {
        this.currentStream.flush();
        this.outputLocked = true;
        if (null != this.callbacks) {
            for (CachedWriterCallback cb : this.callbacks) {
                cb.onClose(this);
            }
        }
        this.doClose();
        this.currentStream.close();
        this.maybeDeleteTempFile(this.currentStream);
        this.postClose();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedWriter) {
            return this.currentStream.equals(((CachedWriter)obj).currentStream);
        }
        return this.currentStream.equals(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetOut(Writer out, boolean copyOldContent) throws IOException {
        if (out == null) {
            out = new LoadingCharArrayWriter();
        }
        if (this.currentStream instanceof CachedWriter) {
            CachedWriter ac = (CachedWriter)this.currentStream;
            Reader in = ac.getReader();
            IOUtils.copyAndCloseInput(in, out);
        } else if (this.inmem) {
            if (!(this.currentStream instanceof LoadingCharArrayWriter)) throw new IOException("Unknown format of currentStream");
            LoadingCharArrayWriter byteOut = (LoadingCharArrayWriter)this.currentStream;
            if (copyOldContent && byteOut.size() > 0) {
                byteOut.writeTo(out);
            }
        } else {
            this.currentStream.close();
            if (copyOldContent) {
                FileInputStream fin = new FileInputStream(this.tempFile);
                IOUtils.copyAndCloseInput(new InputStreamReader((InputStream)fin, "UTF-8"), out);
            }
            this.streamList.remove(this.currentStream);
            this.deleteTempFile();
            this.inmem = true;
        }
        this.currentStream = out;
        this.outputLocked = false;
    }

    public long size() {
        return this.totalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getChars() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof LoadingCharArrayWriter) {
                return ((LoadingCharArrayWriter)this.currentStream).toCharArray();
            }
            throw new IOException("Unknown format of currentStream");
        }
        Reader fin = null;
        try {
            fin = new InputStreamReader((InputStream)new FileInputStream(this.tempFile), "UTF-8");
            CharArrayWriter out = new CharArrayWriter((int)this.tempFile.length());
            char[] bytes = new char[1024];
            int x = fin.read(bytes);
            while (x != -1) {
                out.write(bytes, 0, x);
                x = fin.read(bytes);
            }
            char[] cArray = out.toCharArray();
            return cArray;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(Writer out) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof LoadingCharArrayWriter)) throw new IOException("Unknown format of currentStream");
            ((LoadingCharArrayWriter)this.currentStream).writeTo(out);
            return;
        }
        Reader fin = null;
        try {
            fin = new InputStreamReader((InputStream)new FileInputStream(this.tempFile), "UTF-8");
            char[] bytes = new char[1024];
            int x = fin.read(bytes);
            while (x != -1) {
                out.write(bytes, 0, x);
                x = fin.read(bytes);
            }
            return;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out, long limit) throws IOException {
        this.flush();
        if (this.totalLength < limit || limit == -1L) {
            this.writeCacheTo(out);
            return;
        }
        long count = 0L;
        if (this.inmem) {
            if (!(this.currentStream instanceof LoadingCharArrayWriter)) throw new IOException("Unknown format of currentStream");
            LoadingCharArrayWriter s = (LoadingCharArrayWriter)this.currentStream;
            out.append(s.rawCharArray(), 0, (int)limit);
            return;
        }
        Reader fin = null;
        try {
            fin = new InputStreamReader((InputStream)new FileInputStream(this.tempFile), "UTF-8");
            char[] bytes = new char[1024];
            long x = fin.read(bytes);
            while (x != -1L) {
                if (count + x > limit) {
                    x = limit - count;
                }
                out.append(bytes, 0, (int)x);
                if ((count += x) >= limit) {
                    x = -1L;
                    continue;
                }
                x = fin.read(bytes);
            }
            return;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof LoadingCharArrayWriter)) throw new IOException("Unknown format of currentStream");
            LoadingCharArrayWriter lcaw = (LoadingCharArrayWriter)this.currentStream;
            out.append(lcaw.rawCharArray(), 0, lcaw.size());
            return;
        }
        FileInputStream fin = new FileInputStream(this.tempFile);
        InputStreamReader r = null;
        try {
            r = new InputStreamReader((InputStream)fin, "UTF-8");
            char[] chars = new char[1024];
            int x = r.read(chars);
            while (x != -1) {
                out.append(chars, 0, x);
                x = r.read(chars);
            }
            return;
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
        }
    }

    public Writer getOut() {
        return this.currentStream;
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(CachedWriter.class.getName()).append(" Content: ");
        try {
            this.writeCacheTo(builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.append("]").toString();
    }

    protected void onWrite() throws IOException {
    }

    private void enforceLimits() throws IOException {
        if (this.maxSize > 0L && this.totalLength > this.maxSize) {
            throw new CacheSizeExceededException();
        }
        if (this.inmem && this.totalLength > this.threshold && this.currentStream instanceof LoadingCharArrayWriter) {
            this.createFileOutputStream();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += (long)len;
            this.enforceLimits();
            this.currentStream.write(cbuf, off, len);
        }
    }

    private void createFileOutputStream() throws IOException {
        if (this.tempFileFailed) {
            return;
        }
        LoadingCharArrayWriter bout = (LoadingCharArrayWriter)this.currentStream;
        try {
            this.tempFile = this.outputDir == null ? FileUtils.createTempFile("cos", "tmp") : FileUtils.createTempFile("cos", "tmp", this.outputDir, false);
            FileOutputStream fout = new FileOutputStream(this.tempFile);
            this.currentStream = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            bout.writeTo(this.currentStream);
            this.inmem = false;
            this.streamList.add(this.currentStream);
        }
        catch (Exception ex) {
            this.tempFileFailed = true;
            if (this.currentStream != bout) {
                this.currentStream.close();
            }
            this.deleteTempFile();
            this.inmem = true;
            this.currentStream = bout;
        }
    }

    public File getTempFile() {
        return this.tempFile != null && this.tempFile.exists() ? this.tempFile : null;
    }

    public Reader getReader() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof LoadingCharArrayWriter) {
                LoadingCharArrayWriter lcaw = (LoadingCharArrayWriter)this.currentStream;
                return new CharArrayReader(lcaw.rawCharArray(), 0, lcaw.size());
            }
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.tempFile){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        CachedWriter.this.maybeDeleteTempFile(this);
                    }
                    this.closed = true;
                }
            };
            InputStreamReader r = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            this.streamList.add(r);
            return r;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file was deleted, " + e.toString());
        }
    }

    private synchronized void deleteTempFile() {
        if (this.tempFile != null) {
            File file = this.tempFile;
            this.tempFile = null;
            FileUtils.delete(file);
        }
    }

    private void maybeDeleteTempFile(Object stream) {
        this.streamList.remove(stream);
        if (!this.inmem && this.tempFile != null && this.streamList.isEmpty() && this.allowDeleteOfFile) {
            if (this.currentStream != null) {
                try {
                    this.currentStream.close();
                    this.postClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.deleteTempFile();
            this.currentStream = new LoadingCharArrayWriter();
            this.inmem = true;
        }
    }

    public void setOutputDir(File outputDir) throws IOException {
        this.outputDir = outputDir;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public static void setDefaultMaxSize(long l) {
        if (l == -1L) {
            String s = System.getProperty("org.apache.cxf.io.CachedWriter.MaxSize", "-1");
            l = Long.parseLong(s);
        }
        defaultMaxSize = l;
    }

    public static void setDefaultThreshold(int i) {
        String s;
        if (i == -1 && (i = Integer.parseInt(s = SystemPropertyAction.getProperty("org.apache.cxf.io.CachedWriter.Threshold", "-1"))) <= 0) {
            i = 65536;
        }
        defaultThreshold = i;
    }

    static {
        File f;
        String s = SystemPropertyAction.getPropertyOrNull("org.apache.cxf.io.CachedWriter.OutputDirectory");
        DEFAULT_TEMP_DIR = s != null ? ((f = new File(s)).exists() && f.isDirectory() ? f : null) : null;
        CachedWriter.setDefaultThreshold(-1);
        CachedWriter.setDefaultMaxSize(-1L);
    }

    static class LoadingCharArrayWriter
    extends CharArrayWriter {
        public LoadingCharArrayWriter() {
            super(1024);
        }

        public char[] rawCharArray() {
            return this.buf;
        }
    }
}

