/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import java.io.IOException;
import java.io.OutputStream;
import tachyon.conf.TachyonConf;
import tachyon.underfs.UnderFileSystem;

public final class UnderFileSystemUtils {
    private UnderFileSystemUtils() {
    }

    public static void deleteDir(String path, TachyonConf tachyonConf) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path, tachyonConf);
        if (ufs.exists(path) && !ufs.delete(path, true)) {
            throw new IOException("Folder " + path + " already exists but can not be deleted.");
        }
    }

    public static void mkdirIfNotExists(String path, TachyonConf tachyonConf) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path, tachyonConf);
        if (!ufs.exists(path) && !ufs.mkdirs(path, true)) {
            throw new IOException("Failed to make folder: " + path);
        }
    }

    public static void touch(String path, TachyonConf tachyonConf) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path, tachyonConf);
        OutputStream os = ufs.create(path);
        os.close();
    }
}

