/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import tachyon.network.protocol.RPCBlockWriteRequest;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCResponse;

public class RPCBlockWriteResponse
extends RPCResponse {
    private final long mUserId;
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final RPCResponse.Status mStatus;

    public RPCBlockWriteResponse(long userId, long blockId, long offset, long length, RPCResponse.Status status) {
        this.mUserId = userId;
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mStatus = status;
    }

    public static RPCBlockWriteResponse createErrorResponse(RPCBlockWriteRequest request, RPCResponse.Status status) {
        Preconditions.checkArgument((status != RPCResponse.Status.SUCCESS ? 1 : 0) != 0);
        return new RPCBlockWriteResponse(request.getUserId(), request.getBlockId(), request.getOffset(), request.getLength(), status);
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_WRITE_RESPONSE;
    }

    public static RPCBlockWriteResponse decode(ByteBuf in) {
        long userId = in.readLong();
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        short status = in.readShort();
        return new RPCBlockWriteResponse(userId, blockId, offset, length, RPCResponse.Status.fromShort(status));
    }

    @Override
    public int getEncodedLength() {
        return 34;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mUserId);
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
        out.writeShort((int)this.mStatus.getId());
    }

    public long getUserId() {
        return this.mUserId;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }
}

