/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCRequest;
import tachyon.network.protocol.databuffer.DataBuffer;
import tachyon.network.protocol.databuffer.DataByteBuffer;

public class RPCBlockWriteRequest
extends RPCRequest {
    private final long mUserId;
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final DataBuffer mData;

    public RPCBlockWriteRequest(long userId, long blockId, long offset, long length, DataBuffer data) {
        this.mUserId = userId;
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mData = data;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_WRITE_REQUEST;
    }

    public static RPCBlockWriteRequest decode(ByteBuf in) {
        long userId = in.readLong();
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        DataByteBuffer data = null;
        if (length > 0L) {
            ByteBuffer buffer = ByteBuffer.allocate((int)length);
            in.readBytes(buffer);
            data = new DataByteBuffer(buffer, (int)length);
        }
        return new RPCBlockWriteRequest(userId, blockId, offset, length, data);
    }

    @Override
    public int getEncodedLength() {
        return 32;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mUserId);
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
    }

    @Override
    public DataBuffer getPayloadDataBuffer() {
        return this.mData;
    }

    public long getUserId() {
        return this.mUserId;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }
}

