/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.PrefixList;
import tachyon.TachyonURI;
import tachyon.Version;
import tachyon.client.TachyonFS;
import tachyon.conf.TachyonConf;
import tachyon.underfs.UnderFileSystem;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;

public class UfsUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    private static TachyonURI buildTFSPath(TachyonURI tfsRootPath, TachyonURI ufsRootPath, TachyonURI path) {
        String filePath = path.getPath().substring(ufsRootPath.getPath().length());
        if (filePath.isEmpty()) {
            filePath = path.getPath().substring(ufsRootPath.getPath().lastIndexOf("/") + 1);
        }
        return new TachyonURI(CommonUtils.concatPath(tfsRootPath, filePath));
    }

    private static void loadUfs(TachyonURI tfsAddrRootPath, TachyonURI ufsAddrRootPath, String excludePaths, TachyonConf tachyonConf) throws IOException {
        TachyonFS tfs = TachyonFS.get(tfsAddrRootPath, tachyonConf);
        PrefixList excludePathPrefix = new PrefixList(excludePaths, ";");
        UfsUtils.loadUnderFs(tfs, tfsAddrRootPath, ufsAddrRootPath, excludePathPrefix, tachyonConf);
    }

    public static void loadUnderFs(TachyonFS tfs, TachyonURI tachyonPath, TachyonURI ufsAddrRootPath, PrefixList excludePathPrefix, TachyonConf tachyonConf) throws IOException {
        int lastSlashPos;
        LOG.info("Loading to " + tachyonPath + " " + ufsAddrRootPath + " " + excludePathPrefix);
        try {
            ufsAddrRootPath = NetworkUtils.replaceHostName(ufsAddrRootPath);
            tachyonPath = NetworkUtils.replaceHostName(tachyonPath);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve hostname", (Throwable)e);
            throw new IOException(e);
        }
        Pair<String, String> ufsPair = UnderFileSystem.parse(ufsAddrRootPath, tachyonConf);
        String ufsAddress = ufsPair.getFirst();
        String ufsRootPath = ufsPair.getSecond();
        LOG.debug("Loading ufs, address:" + ufsAddress + "; root path: " + ufsRootPath);
        UnderFileSystem ufs = UnderFileSystem.get(ufsAddress, tachyonConf);
        if (!ufs.exists(ufsAddrRootPath.toString())) {
            throw new FileNotFoundException("ufs path " + ufsAddrRootPath + " not found.");
        }
        TachyonURI directoryName = ufs.isFile(ufsAddrRootPath.toString()) ? (ufsRootPath == null || ufsRootPath.isEmpty() || ufsRootPath.equals("/") ? TachyonURI.EMPTY_URI : ((lastSlashPos = ufsRootPath.lastIndexOf(47)) > 0 ? new TachyonURI(ufsRootPath.substring(0, lastSlashPos)) : TachyonURI.EMPTY_URI)) : tachyonPath;
        if (!directoryName.equals(TachyonURI.EMPTY_URI) && !tfs.exist(directoryName)) {
            LOG.debug("Loading ufs. Make dir if needed for '" + directoryName + "'.");
            tfs.mkdir(directoryName);
        }
        LinkedList<TachyonURI> ufsPathQueue = new LinkedList<TachyonURI>();
        if (excludePathPrefix.outList(ufsRootPath)) {
            ufsPathQueue.add(ufsAddrRootPath);
        }
        while (!ufsPathQueue.isEmpty()) {
            TachyonURI ufsPath = (TachyonURI)ufsPathQueue.poll();
            LOG.info("Loading: " + ufsPath);
            if (ufs.isFile(ufsPath.toString())) {
                TachyonURI tfsPath = UfsUtils.buildTFSPath(directoryName, ufsAddrRootPath, ufsPath);
                LOG.debug("Loading ufs. tfs path = " + tfsPath + ".");
                if (tfs.exist(tfsPath)) {
                    LOG.info("File " + tfsPath + " already exists in Tachyon.");
                    continue;
                }
                int fileId = tfs.createFile(tfsPath, ufsPath);
                if (fileId == -1) {
                    LOG.warn("Failed to create tachyon file: " + tfsPath);
                    continue;
                }
                LOG.info("Create tachyon file " + tfsPath + " with file id " + fileId + " and " + "checkpoint location " + ufsPath);
                continue;
            }
            LOG.debug("Loading ufs. ufs path is a directory.");
            String[] files = ufs.list(ufsPath.toString());
            if (files != null) {
                for (String filePath : files) {
                    if (filePath.isEmpty()) continue;
                    LOG.info("Get: " + filePath);
                    String aPath = CommonUtils.concatPath(ufsPath, filePath);
                    String checkPath = aPath.substring(ufsAddrRootPath.toString().length());
                    if (checkPath.startsWith("/")) {
                        checkPath = checkPath.substring("/".length());
                    }
                    if (excludePathPrefix.inList(checkPath)) {
                        LOG.info("excluded: " + checkPath);
                        continue;
                    }
                    ufsPathQueue.add(new TachyonURI(aPath));
                }
            }
            TachyonURI tfsPath = new TachyonURI(CommonUtils.concatPath(tachyonPath, ufsPath.getPath().substring(ufsAddrRootPath.getPath().length())));
            LOG.debug("Loading ufs. ufs path is a directory. tfsPath = " + tfsPath + ".");
            if (tfs.exist(tfsPath)) continue;
            LOG.debug("Loading ufs. ufs path is a directory. make dir = " + tfsPath + ".");
            tfs.mkdir(tfsPath);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            UfsUtils.printUsage();
            System.exit(-1);
        }
        String exList = args.length == 3 ? args[2] : "";
        try {
            UfsUtils.loadUfs(new TachyonURI(args[0]), new TachyonURI(args[1]), exList, new TachyonConf());
        }
        catch (Exception e) {
            e.printStackTrace();
            UfsUtils.printUsage();
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void printUsage() {
        String cmd = "java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.client.UfsUtils ";
        System.out.println("Usage: " + cmd + "<TachyonPath> <UfsPath> " + "[<Optional ExcludePathPrefix, separated by ;>]");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a hdfs://localhost:9000/b c");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a file:///b c");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a /b c");
        System.out.print("In the TFS, all files under local FS /b will be registered under /a, ");
        System.out.println("except for those with prefix c");
    }
}

