/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.AbstractTachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.table.RawTable;
import tachyon.conf.TachyonConf;
import tachyon.master.MasterClient;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.underfs.UnderFileSystem;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;
import tachyon.util.ThreadFactoryUtils;
import tachyon.worker.ClientMetrics;
import tachyon.worker.WorkerClient;

public class TachyonFS
extends AbstractTachyonFS {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final int mUserFailedSpaceRequestLimits;
    private final ExecutorService mExecutorService;
    private final MasterClient mMasterClient;
    private final InetSocketAddress mMasterAddress;
    private final WorkerClient mWorkerClient;
    private final Closer mCloser = Closer.create();
    private final boolean mZookeeperMode;
    private final Map<String, ClientFileInfo> mPathToClientFileInfo = new HashMap<String, ClientFileInfo>();
    private final Map<Integer, ClientFileInfo> mIdToClientFileInfo = new HashMap<Integer, ClientFileInfo>();
    private UnderFileSystem mUnderFileSystem;
    private final Map<Long, Set<Integer>> mLockedBlockIds = new HashMap<Long, Set<Integer>>();
    private final Map<Long, String> mLockedBlockIdToPath = new HashMap<Long, String>();
    private final AtomicInteger mBlockLockId = new AtomicInteger(0);
    private TachyonURI mRootUri = null;
    private ClientMetrics mClientMetrics = new ClientMetrics();

    @Deprecated
    public static synchronized TachyonFS get(String tachyonPath) throws IOException {
        return TachyonFS.get(new TachyonURI(tachyonPath), new TachyonConf());
    }

    @Deprecated
    public static synchronized TachyonFS get(TachyonURI tachyonURI) throws IOException {
        return TachyonFS.get(tachyonURI, new TachyonConf());
    }

    public static synchronized TachyonFS get(TachyonURI tachyonURI, TachyonConf tachyonConf) throws IOException {
        Preconditions.checkNotNull((Object)tachyonConf, (Object)"Could not pass null TachyonConf instance.");
        if (tachyonURI == null) {
            throw new IOException("Tachyon Uri cannot be null. Use tachyon://host:port/ ,tachyon-ft://host:port/");
        }
        String scheme = tachyonURI.getScheme();
        if (scheme == null || tachyonURI.getHost() == null || tachyonURI.getPort() == -1 || !"tachyon".equals(scheme) && !"tachyon-ft".equals(scheme)) {
            throw new IOException("Invalid Tachyon URI: " + tachyonURI + ". Use " + "tachyon://" + "host:port/ ," + "tachyon-ft://" + "host:port/");
        }
        boolean useZookeeper = scheme.equals("tachyon-ft");
        tachyonConf.set("tachyon.usezookeeper", Boolean.toString(useZookeeper));
        tachyonConf.set("tachyon.master.hostname", tachyonURI.getHost());
        tachyonConf.set("tachyon.master.port", Integer.toString(tachyonURI.getPort()));
        return TachyonFS.get(tachyonConf);
    }

    public static synchronized TachyonFS get(String masterHost, int masterPort, boolean zkMode) throws IOException {
        TachyonConf tachyonConf = new TachyonConf();
        tachyonConf.set("tachyon.master.hostname", masterHost);
        tachyonConf.set("tachyon.master.port", Integer.toString(masterPort));
        tachyonConf.set("tachyon.usezookeeper", Boolean.toString(zkMode));
        return TachyonFS.get(tachyonConf);
    }

    public static synchronized TachyonFS get(TachyonConf tachyonConf) throws IOException {
        Preconditions.checkArgument((tachyonConf != null ? 1 : 0) != 0, (Object)"Could not pass null TachyonConf instance.");
        return new TachyonFS(tachyonConf);
    }

    private TachyonFS(TachyonConf tachyonConf) throws IOException {
        super(tachyonConf);
        String masterHost = tachyonConf.get("tachyon.master.hostname", NetworkUtils.getLocalHostName(tachyonConf));
        int masterPort = tachyonConf.getInt("tachyon.master.port", 19998);
        this.mMasterAddress = new InetSocketAddress(masterHost, masterPort);
        this.mZookeeperMode = this.mTachyonConf.getBoolean("tachyon.usezookeeper", false);
        this.mExecutorService = Executors.newFixedThreadPool(2, ThreadFactoryUtils.build("client-heartbeat-%d", true));
        this.mMasterClient = (MasterClient)this.mCloser.register((Closeable)new MasterClient(this.mMasterAddress, this.mExecutorService, this.mTachyonConf));
        this.mWorkerClient = (WorkerClient)this.mCloser.register((Closeable)new WorkerClient(this.mMasterClient, this.mExecutorService, this.mTachyonConf, this.mClientMetrics));
        this.mUserFailedSpaceRequestLimits = this.mTachyonConf.getInt("tachyon.user.failed.space.request.limits", 3);
        String scheme = this.mZookeeperMode ? "tachyon-ft" : "tachyon";
        String authority = this.mMasterAddress.getHostName() + ":" + this.mMasterAddress.getPort();
        this.mRootUri = new TachyonURI(scheme, authority, "/");
    }

    synchronized void accessLocalBlock(long blockId) throws IOException {
        if (this.mWorkerClient.isLocal()) {
            this.mWorkerClient.accessBlock(blockId);
        }
    }

    synchronized void addCheckpoint(int fid) throws IOException {
        this.mWorkerClient.addCheckpoint(fid);
    }

    synchronized boolean asyncCheckpoint(int fid) throws IOException {
        return this.mWorkerClient.asyncCheckpoint(fid);
    }

    public synchronized void cacheBlock(long blockId) throws IOException {
        this.mWorkerClient.cacheBlock(blockId);
    }

    public synchronized void cancelBlock(long blockId) throws IOException {
        this.mWorkerClient.cancelBlock(blockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            this.mCloser.close();
        }
        finally {
            this.mExecutorService.shutdown();
        }
    }

    synchronized void completeFile(int fid) throws IOException {
        this.mMasterClient.user_completeFile(fid);
    }

    synchronized String createAndGetUserUfsTempFolder(Object ufsConf) throws IOException {
        String tmpFolder = this.mWorkerClient.getUserUfsTempFolder();
        if (tmpFolder == null) {
            return null;
        }
        if (this.mUnderFileSystem == null) {
            this.mUnderFileSystem = UnderFileSystem.get(tmpFolder, ufsConf, this.mTachyonConf);
        }
        this.mUnderFileSystem.mkdirs(tmpFolder, true);
        return tmpFolder;
    }

    public synchronized int createDependency(List<String> parents, List<String> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, int dependencyType, long childrenBlockSizeByte) throws IOException {
        return this.mMasterClient.user_createDependency(parents, children, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, childrenBlockSizeByte);
    }

    @Override
    public synchronized int createFile(TachyonURI path, TachyonURI ufsPath, long blockSizeByte, boolean recursive) throws IOException {
        this.validateUri(path);
        return this.mMasterClient.user_createFile(path.getPath(), ufsPath.toString(), blockSizeByte, recursive);
    }

    public synchronized int createRawTable(TachyonURI path, int columns) throws IOException {
        return this.createRawTable(path, columns, ByteBuffer.allocate(0));
    }

    public synchronized int createRawTable(TachyonURI path, int columns, ByteBuffer metadata) throws IOException {
        this.validateUri(path);
        int maxColumns = this.mTachyonConf.getInt("tachyon.max.columns", 1000);
        if (columns < 1 || columns > maxColumns) {
            throw new IOException("Column count " + columns + " is smaller than 1 or " + "bigger than " + maxColumns);
        }
        return this.mMasterClient.user_createRawTable(path.getPath(), columns, metadata);
    }

    @Override
    public synchronized boolean delete(int fileId, TachyonURI path, boolean recursive) throws IOException {
        this.validateUri(path);
        return this.mMasterClient.user_delete(fileId, path.getPath(), recursive);
    }

    public synchronized boolean exist(TachyonURI path) throws IOException {
        return this.getFileStatus(-1, path, false) != null;
    }

    public synchronized long getBlockId(int fileId, int blockIndex) throws IOException {
        ClientFileInfo info = this.getFileStatus(fileId, true);
        if (info == null) {
            throw new IOException("File " + fileId + " does not exist.");
        }
        if (info.blockIds.size() > blockIndex) {
            return info.blockIds.get(blockIndex);
        }
        return this.mMasterClient.user_getBlockId(fileId, blockIndex);
    }

    synchronized int getBlockLockId() {
        return this.mBlockLockId.getAndIncrement();
    }

    synchronized ClientBlockInfo getClientBlockInfo(long blockId) throws IOException {
        return this.mMasterClient.user_getClientBlockInfo(blockId);
    }

    public synchronized ClientDependencyInfo getClientDependencyInfo(int depId) throws IOException {
        return this.mMasterClient.getClientDependencyInfo(depId);
    }

    ClientMetrics getClientMetrics() {
        return this.mClientMetrics;
    }

    public synchronized TachyonFile getFile(int fid) throws IOException {
        return this.getFile(fid, true);
    }

    public synchronized TachyonFile getFile(int fid, boolean useCachedMetadata) throws IOException {
        ClientFileInfo clientFileInfo = this.getFileStatus(fid, TachyonURI.EMPTY_URI, useCachedMetadata);
        if (clientFileInfo == null) {
            return null;
        }
        return new TachyonFile(this, fid, this.mTachyonConf);
    }

    public synchronized TachyonFile getFile(TachyonURI path) throws IOException {
        this.validateUri(path);
        return this.getFile(path, false);
    }

    public synchronized TachyonFile getFile(TachyonURI path, boolean useCachedMetadata) throws IOException {
        this.validateUri(path);
        ClientFileInfo clientFileInfo = this.getFileStatus(-1, path, useCachedMetadata);
        if (clientFileInfo == null) {
            return null;
        }
        return new TachyonFile(this, clientFileInfo.getId(), this.mTachyonConf);
    }

    public synchronized List<ClientBlockInfo> getFileBlocks(int fid) throws IOException {
        return this.mMasterClient.user_getFileBlocks(fid, "");
    }

    public synchronized int getFileId(TachyonURI path) {
        try {
            ClientFileInfo fileInfo = this.getFileStatus(-1, path, false);
            return fileInfo == null ? -1 : fileInfo.getId();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private synchronized <K> ClientFileInfo getFileStatus(Map<K, ClientFileInfo> cache, K key, int fileId, String path, boolean useCachedMetaData) throws IOException {
        ClientFileInfo info = null;
        if (useCachedMetaData && (info = cache.get(key)) != null) {
            return info;
        }
        info = this.mMasterClient.getFileStatus(fileId, path);
        if ((fileId = info.getId()) == -1) {
            cache.remove(key);
            return null;
        }
        path = info.getPath();
        this.mIdToClientFileInfo.put(fileId, info);
        this.mPathToClientFileInfo.put(path, info);
        return info;
    }

    public synchronized ClientFileInfo getFileStatus(int fileId, TachyonURI path, boolean useCachedMetadata) throws IOException {
        if (fileId != -1) {
            return this.getFileStatus(this.mIdToClientFileInfo, fileId, fileId, TachyonURI.EMPTY_URI.getPath(), useCachedMetadata);
        }
        this.validateUri(path);
        String p = path.getPath();
        return this.getFileStatus(this.mPathToClientFileInfo, p, fileId, p, useCachedMetadata);
    }

    @Override
    public ClientFileInfo getFileStatus(int fileId, TachyonURI path) throws IOException {
        return this.getFileStatus(fileId, path, false);
    }

    public synchronized ClientFileInfo getFileStatus(int fileId, boolean useCachedMetadata) throws IOException {
        return this.getFileStatus(fileId, TachyonURI.EMPTY_URI, useCachedMetadata);
    }

    public synchronized String getLocalBlockTemporaryPath(long blockId, long initialBytes) throws IOException {
        String blockPath = this.mWorkerClient.requestBlockLocation(blockId, initialBytes);
        CommonUtils.createBlockPath(blockPath);
        return blockPath;
    }

    public synchronized RawTable getRawTable(int id) throws IOException {
        ClientRawTableInfo clientRawTableInfo = this.mMasterClient.user_getClientRawTableInfo(id, "");
        return new RawTable(this, clientRawTableInfo);
    }

    public synchronized RawTable getRawTable(TachyonURI path) throws IOException {
        this.validateUri(path);
        ClientRawTableInfo clientRawTableInfo = this.mMasterClient.user_getClientRawTableInfo(-1, path.getPath());
        return new RawTable(this, clientRawTableInfo);
    }

    public synchronized String getUfsAddress() throws IOException {
        return this.mMasterClient.user_getUfsAddress();
    }

    @Override
    public synchronized TachyonURI getUri() {
        return this.mRootUri;
    }

    long getUserId() throws IOException {
        return this.mMasterClient.getUserId();
    }

    public synchronized long getUsedBytes() throws IOException {
        return this.mMasterClient.getUsedBytes();
    }

    public synchronized long getCapacityBytes() throws IOException {
        return this.mMasterClient.getCapacityBytes();
    }

    public synchronized InetSocketAddress getWorkerDataServerAddress() {
        return this.mWorkerClient.getDataServerAddress();
    }

    public synchronized List<ClientWorkerInfo> getWorkersInfo() throws IOException {
        return this.mMasterClient.getWorkersInfo();
    }

    public synchronized boolean hasLocalWorker() throws IOException {
        return this.mWorkerClient.isLocal();
    }

    public synchronized boolean isConnected() {
        return this.mMasterClient.isConnected();
    }

    synchronized boolean isDirectory(int fid) {
        return this.mIdToClientFileInfo.get((Object)Integer.valueOf((int)fid)).isFolder;
    }

    @Override
    public synchronized List<ClientFileInfo> listStatus(TachyonURI path) throws IOException {
        this.validateUri(path);
        return this.mMasterClient.listStatus(path.getPath());
    }

    synchronized String lockBlock(long blockId, int blockLockId) throws IOException {
        if (blockId <= 0L || blockLockId < 0) {
            return null;
        }
        if (this.mLockedBlockIds.containsKey(blockId)) {
            this.mLockedBlockIds.get(blockId).add(blockLockId);
            return this.mLockedBlockIdToPath.get(blockId);
        }
        if (!this.mWorkerClient.isLocal()) {
            return null;
        }
        String blockPath = this.mWorkerClient.lockBlock(blockId);
        if (blockPath != null) {
            HashSet<Integer> lockIds = new HashSet<Integer>(4);
            lockIds.add(blockLockId);
            this.mLockedBlockIds.put(blockId, lockIds);
            this.mLockedBlockIdToPath.put(blockId, blockPath);
            return blockPath;
        }
        return null;
    }

    @Override
    public synchronized boolean mkdirs(TachyonURI path, boolean recursive) throws IOException {
        this.validateUri(path);
        return this.mMasterClient.user_mkdirs(path.getPath(), recursive);
    }

    public synchronized void pinFile(int fid) throws IOException {
        this.setPinned(fid, true);
    }

    @Override
    public synchronized boolean freepath(int fileId, TachyonURI path, boolean recursive) throws IOException {
        this.validateUri(path);
        return this.mMasterClient.user_freepath(fileId, path.getPath(), recursive);
    }

    public synchronized boolean promoteBlock(long blockId) throws IOException {
        if (this.mWorkerClient.isLocal()) {
            return this.mWorkerClient.promoteBlock(blockId);
        }
        return false;
    }

    @Override
    public synchronized boolean rename(int fileId, TachyonURI srcPath, TachyonURI dstPath) throws IOException {
        this.validateUri(srcPath);
        this.validateUri(dstPath);
        return this.mMasterClient.user_rename(fileId, srcPath.getPath(), dstPath.getPath());
    }

    public synchronized void reportLostFile(int fileId) throws IOException {
        this.mMasterClient.user_reportLostFile(fileId);
    }

    public synchronized void requestFilesInDependency(int depId) throws IOException {
        this.mMasterClient.user_requestFilesInDependency(depId);
    }

    public synchronized long requestSpace(long blockId, long requestSpaceBytes) throws IOException {
        if (!this.hasLocalWorker()) {
            return -1L;
        }
        long userQuotaUnitBytes = this.mTachyonConf.getBytes("tachyon.user.quota.unit.bytes", 0x800000L);
        long toRequestSpaceBytes = Math.max(requestSpaceBytes, userQuotaUnitBytes);
        for (int attempt = 0; attempt < this.mUserFailedSpaceRequestLimits; ++attempt) {
            if (!this.mWorkerClient.requestSpace(blockId, toRequestSpaceBytes)) continue;
            return toRequestSpaceBytes;
        }
        return 0L;
    }

    public synchronized void setPinned(int fid, boolean pinned) throws IOException {
        this.mMasterClient.user_setPinned(fid, pinned);
    }

    public String toString() {
        return (this.mZookeeperMode ? "tachyon-ft://" : "tachyon://") + this.mMasterAddress.toString();
    }

    synchronized boolean unlockBlock(long blockId, int blockLockId) throws IOException {
        if (blockId <= 0L || blockLockId < 0) {
            return false;
        }
        if (!this.mLockedBlockIds.containsKey(blockId)) {
            return true;
        }
        Set<Integer> lockIds = this.mLockedBlockIds.get(blockId);
        lockIds.remove(blockLockId);
        if (!lockIds.isEmpty()) {
            return true;
        }
        if (!this.mWorkerClient.isLocal()) {
            return false;
        }
        this.mLockedBlockIdToPath.remove(blockId);
        this.mLockedBlockIds.remove(blockId);
        return this.mWorkerClient.unlockBlock(blockId);
    }

    public synchronized void unpinFile(int fid) throws IOException {
        this.setPinned(fid, false);
    }

    public synchronized void updateRawTableMetadata(int id, ByteBuffer metadata) throws IOException {
        this.mMasterClient.user_updateRawTableMetadata(id, metadata);
    }

    private void validateUri(TachyonURI uri) throws IOException {
        String err = null;
        if (uri == null) {
            err = "URI cannot be null";
        } else if (!uri.isPathAbsolute() && !TachyonURI.EMPTY_URI.equals(uri)) {
            err = "URI must be absolute";
        } else if (uri.hasScheme() && !this.mRootUri.getScheme().equals(uri.getScheme())) {
            err = "URI's scheme: " + uri.getScheme() + " must match the file system's scheme: " + this.mRootUri.getScheme();
        } else if (uri.hasAuthority() && !this.mRootUri.getAuthority().equals(uri.getAuthority())) {
            err = "URI's authority: " + uri.getAuthority() + " must match the file system's authority: " + this.mRootUri.getAuthority();
        }
        if (err != null) {
            throw new IOException("Uri is invalid: " + err);
        }
    }
}

