/*
 * $Id$
 */

package org.apache.maven.profiles;

/**
 * Root element of the profiles.xml file.
 * 
 * @version $Revision$ $Date$
 */
public class ProfilesRoot implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field profiles
     */
    private java.util.List profiles;

    /**
     * Field activeProfiles
     */
    private java.util.List activeProfiles;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addActiveProfile
     * 
     * @param string
     */
    public void addActiveProfile(String string)
    {
        getActiveProfiles().add( string );
    } //-- void addActiveProfile(String) 

    /**
     * Method addProfile
     * 
     * @param profile
     */
    public void addProfile(Profile profile)
    {
        getProfiles().add( profile );
    } //-- void addProfile(Profile) 

    /**
     * Method getActiveProfiles
     */
    public java.util.List getActiveProfiles()
    {
        if ( this.activeProfiles == null )
        {
            this.activeProfiles = new java.util.ArrayList();
        }
        
        return this.activeProfiles;
    } //-- java.util.List getActiveProfiles() 

    /**
     * Method getProfiles
     */
    public java.util.List getProfiles()
    {
        if ( this.profiles == null )
        {
            this.profiles = new java.util.ArrayList();
        }
        
        return this.profiles;
    } //-- java.util.List getProfiles() 

    /**
     * Method removeActiveProfile
     * 
     * @param string
     */
    public void removeActiveProfile(String string)
    {
        getActiveProfiles().remove( string );
    } //-- void removeActiveProfile(String) 

    /**
     * Method removeProfile
     * 
     * @param profile
     */
    public void removeProfile(Profile profile)
    {
        getProfiles().remove( profile );
    } //-- void removeProfile(Profile) 

    /**
     * Set 
     *             List of manually-activated build profiles,
     * specified in the order in which
     *             they should be applied.
     *           
     * 
     * @param activeProfiles
     */
    public void setActiveProfiles(java.util.List activeProfiles)
    {
        this.activeProfiles = activeProfiles;
    } //-- void setActiveProfiles(java.util.List) 

    /**
     * Set 
     *             Configuration of build profiles for adjusting
     * the build 
     *             according to environmental parameters
     *           
     * 
     * @param profiles
     */
    public void setProfiles(java.util.List profiles)
    {
        this.profiles = profiles;
    } //-- void setProfiles(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
