/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XASession;
import javax.transaction.TransactionManager;
import org.apache.cxf.transport.jms.util.AbstractMessageListenerContainer;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class MessageListenerContainer
extends AbstractMessageListenerContainer {
    public MessageListenerContainer(Connection connection, Destination destination, MessageListener listenerHandler) {
        this.connection = connection;
        this.destination = destination;
        this.listenerHandler = listenerHandler;
    }

    @Override
    public void start() {
        try {
            this.session = this.connection.createSession(this.transacted, this.acknowledgeMode);
            this.consumer = this.durableSubscriptionName != null && this.destination instanceof Topic ? this.session.createDurableSubscriber((Topic)this.destination, this.durableSubscriptionName, this.messageSelector, this.pubSubNoLocal) : this.session.createConsumer(this.destination, this.messageSelector);
            LocalTransactionalMessageListener intListener = new LocalTransactionalMessageListener(this.session, this.listenerHandler);
            this.consumer.setMessageListener((MessageListener)intListener);
            this.running = true;
        }
        catch (JMSException e) {
            throw JMSUtil.convertJmsException(e);
        }
    }

    @Override
    public void stop() {
        this.running = false;
        ResourceCloser.close(this.consumer);
        ResourceCloser.close(this.session);
        this.consumer = null;
        this.session = null;
    }

    @Override
    public void shutdown() {
        this.stop();
        ResourceCloser.close(this.connection);
    }

    static class XATransactionalMessageListener
    implements MessageListener {
        private TransactionManager tm;
        private MessageListener listenerHandler;
        private XASession session;

        public XATransactionalMessageListener(TransactionManager tm, Session session, MessageListener listenerHandler) {
            if (tm == null) {
                throw new IllegalArgumentException("Must supply a transaction manager");
            }
            if (!(session instanceof XASession)) {
                throw new IllegalArgumentException("Must supply an XASession");
            }
            this.tm = tm;
            this.session = (XASession)session;
            this.listenerHandler = listenerHandler;
        }

        public void onMessage(Message message) {
            try {
                this.tm.begin();
                this.tm.getTransaction().enlistResource(this.session.getXAResource());
                this.listenerHandler.onMessage(message);
                this.tm.commit();
            }
            catch (Throwable e) {
                this.safeRollback(e);
            }
        }

        private void safeRollback(Throwable t) {
            AbstractMessageListenerContainer.LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", t);
            try {
                this.tm.rollback();
            }
            catch (Exception e) {
                AbstractMessageListenerContainer.LOG.log(Level.WARNING, "Rollback of JTA transaction failed", e);
            }
        }
    }

    static class LocalTransactionalMessageListener
    implements MessageListener {
        private MessageListener listenerHandler;
        private Session session;

        public LocalTransactionalMessageListener(Session session, MessageListener listenerHandler) {
            this.session = session;
            this.listenerHandler = listenerHandler;
        }

        public void onMessage(Message message) {
            try {
                this.listenerHandler.onMessage(message);
                if (this.session.getTransacted()) {
                    this.session.commit();
                }
            }
            catch (Throwable e) {
                this.safeRollback(e);
            }
        }

        private void safeRollback(Throwable t) {
            AbstractMessageListenerContainer.LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", t);
            try {
                this.session.rollback();
            }
            catch (Exception e) {
                AbstractMessageListenerContainer.LOG.log(Level.WARNING, "Rollback of Local transaction failed", e);
            }
        }
    }

    static class DispachingListener
    implements MessageListener {
        private Executor executor;
        private MessageListener listenerHandler;

        public DispachingListener(Executor executor, MessageListener listenerHandler) {
            this.executor = executor;
            this.listenerHandler = listenerHandler;
        }

        public void onMessage(final Message message) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    DispachingListener.this.listenerHandler.onMessage(message);
                }
            });
        }
    }
}

