/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.reports;

import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.form.FormPropertiesForm;
import org.activiti.explorer.ui.reports.ChartComponent;
import org.activiti.explorer.ui.reports.ChartGenerator;
import org.activiti.explorer.ui.reports.SavedReportListItem;
import org.activiti.explorer.util.time.HumanTime;

public class SavedReportDetailPanel
extends DetailPanel {
    private static final long serialVersionUID = 1L;
    protected HistoricProcessInstance historicProcessInstance;
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected VerticalLayout detailPanelLayout;
    protected HorizontalLayout detailContainer;
    protected FormPropertiesForm processDefinitionStartForm;

    public SavedReportDetailPanel(String historicProcessInstance) {
        this.historicProcessInstance = (HistoricProcessInstance)ProcessEngines.getDefaultProcessEngine().getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(historicProcessInstance).singleResult();
        this.initUi();
    }

    protected void initUi() {
        this.setSizeFull();
        this.addStyleName("white");
        this.detailPanelLayout = new VerticalLayout();
        this.detailPanelLayout.setWidth(100.0f, 8);
        this.detailPanelLayout.setMargin(true);
        this.setDetailContainer((ComponentContainer)this.detailPanelLayout);
        this.initHeader();
        this.detailContainer = new HorizontalLayout();
        this.detailContainer.addStyleName("light");
        this.detailPanelLayout.addComponent((Component)this.detailContainer);
        this.detailContainer.setSizeFull();
        this.initForm();
    }

    protected void initHeader() {
        GridLayout details = new GridLayout(2, 2);
        details.setWidth(100.0f, 8);
        details.addStyleName("title-block");
        details.setSpacing(true);
        details.setMargin(false, false, true, false);
        details.setColumnExpandRatio(1, 1.0f);
        this.detailPanelLayout.addComponent((Component)details);
        Embedded image = new Embedded(null, Images.REPORT_50);
        details.addComponent((Component)image, 0, 0, 0, 1);
        Label nameLabel = new Label(SavedReportListItem.getReportDisplayName(this.historicProcessInstance));
        nameLabel.addStyleName("h2");
        details.addComponent((Component)nameLabel, 1, 0);
        HorizontalLayout propertiesLayout = new HorizontalLayout();
        propertiesLayout.setSpacing(true);
        details.addComponent((Component)propertiesLayout);
        String createLabel = this.i18nManager.getMessage("reporting.report.created", new HumanTime(this.i18nManager).format(this.historicProcessInstance.getEndTime()));
        Label versionLabel = new Label(createLabel);
        versionLabel.addStyleName("process-start-time");
        propertiesLayout.addComponent((Component)versionLabel);
    }

    protected void initForm() {
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)ProcessEngines.getDefaultProcessEngine().getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(this.historicProcessInstance.getId()).variableName("reportData").singleResult();
        byte[] reportData = (byte[])historicVariableInstance.getValue();
        ChartComponent chart = ChartGenerator.generateChart(reportData);
        chart.setWidth(100.0f, 8);
        chart.setHeight(100.0f, 8);
        this.detailContainer.addComponent((Component)chart);
    }
}

