/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.reports;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.reports.ReportListItem;

public class ReportListQuery
extends AbstractLazyLoadingQuery {
    private static final long serialVersionUID = -7865037930384885968L;
    private static final String REPORT_PROCESS_CATEGORY = "activiti-report";
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();

    @Override
    public int size() {
        return (int)this.createQuery().count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List processDefinitions = this.createQuery().listPage(start, count);
        ArrayList<Item> reportItems = new ArrayList<Item>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            reportItems.add((Item)new ReportListItem(processDefinition));
        }
        return reportItems;
    }

    protected ProcessDefinitionQuery createQuery() {
        return (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionCategory(REPORT_PROCESS_CATEGORY).latestVersion().orderByProcessDefinitionName().asc();
    }

    @Override
    public Item loadSingleResult(String id) {
        return new ReportListItem((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult());
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }
}

