/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process.simple.editor.table;

import com.vaadin.data.Item;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.process.simple.editor.listener.AddTaskClickListener;
import org.activiti.explorer.ui.process.simple.editor.listener.DeleteTaskClickListener;
import org.activiti.explorer.ui.process.simple.editor.listener.ShowFormClickListener;
import org.activiti.explorer.ui.process.simple.editor.listener.TaskFormModelListener;
import org.activiti.explorer.ui.process.simple.editor.table.TaskFormModel;
import org.activiti.workflow.simple.definition.HumanStepDefinition;
import org.activiti.workflow.simple.definition.form.FormDefinition;
import org.apache.commons.lang3.StringUtils;

public class TaskTable
extends Table
implements TaskFormModelListener {
    private static final long serialVersionUID = -2578437667358797351L;
    public static final String ID_NAME = "name";
    public static final String ID_ASSIGNEE = "assignee";
    public static final String ID_GROUPS = "groups";
    public static final String ID_DESCRIPTION = "description";
    public static final String ID_START_WITH_PREVIOUS = "startWithPrevious";
    public static final String ID_ACTIONS = "actions";
    protected I18nManager i18nManager;
    protected TaskFormModel taskFormModel = new TaskFormModel();

    public TaskTable() {
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.taskFormModel.addFormModelListener(this);
        this.setEditable(true);
        this.setColumnReorderingAllowed(true);
        this.setSizeFull();
        this.setPageLength(0);
        this.addContainerProperty(ID_NAME, String.class, null);
        this.addContainerProperty(ID_ASSIGNEE, ComboBox.class, null);
        this.addContainerProperty(ID_GROUPS, ComboBox.class, null);
        this.addContainerProperty(ID_DESCRIPTION, TextField.class, null);
        this.addContainerProperty(ID_START_WITH_PREVIOUS, CheckBox.class, null);
        this.addContainerProperty(ID_ACTIONS, HorizontalLayout.class, null);
        this.setColumnHeader(ID_NAME, this.i18nManager.getMessage("process.editor.task.name"));
        this.setColumnHeader(ID_ASSIGNEE, this.i18nManager.getMessage("process.editor.task.assignee"));
        this.setColumnHeader(ID_GROUPS, this.i18nManager.getMessage("process.editor.task.groups"));
        this.setColumnHeader(ID_DESCRIPTION, this.i18nManager.getMessage("process.editor.task.description"));
        this.setColumnHeader(ID_START_WITH_PREVIOUS, this.i18nManager.getMessage("process.editor.task.concurrency"));
        this.setColumnHeader(ID_ACTIONS, this.i18nManager.getMessage("process.editor.actions"));
        this.setColumnAlignment(ID_NAME, "c");
        this.setColumnAlignment(ID_ASSIGNEE, "c");
        this.setColumnAlignment(ID_GROUPS, "c");
        this.setColumnAlignment(ID_START_WITH_PREVIOUS, "c");
        this.setColumnAlignment(ID_START_WITH_PREVIOUS, "c");
        this.setColumnWidth(ID_ACTIONS, 170);
    }

    public void addTaskRow(HumanStepDefinition humanStepDefinition) {
        Object taskItemId = this.addTaskRow(null, humanStepDefinition.getName(), humanStepDefinition.getAssignee(), this.getCommaSeperated(humanStepDefinition.getCandidateGroups()), humanStepDefinition.getDescription(), humanStepDefinition.isStartsWithPrevious());
        if (humanStepDefinition.getForm() != null) {
            this.taskFormModel.addForm(taskItemId, humanStepDefinition.getForm());
        }
    }

    protected String getCommaSeperated(List<String> list) {
        if (list != null && list.size() > 0) {
            return StringUtils.join(list, (String)", ");
        }
        return null;
    }

    public void addDefaultTaskRow() {
        this.addDefaultTaskRowAfter(null);
    }

    public void addDefaultTaskRowAfter(Object itemId) {
        this.addTaskRow(itemId, null, null, null, null, null);
    }

    protected Object addTaskRow(Object previousTaskItemId, String taskName, String taskAssignee, String taskGroups, String taskDescription, Boolean startWithPrevious) {
        Object newItemId = null;
        newItemId = previousTaskItemId == null ? this.addItem() : this.addItemAfter(previousTaskItemId);
        Item newItem = this.getItem(newItemId);
        newItem.getItemProperty((Object)ID_NAME).setValue((Object)(taskName == null ? "my task" : taskName));
        ComboBox assigneeComboBox = new ComboBox();
        assigneeComboBox.setNullSelectionAllowed(true);
        try {
            for (User user : ((UserQuery)ProcessEngines.getDefaultProcessEngine().getIdentityService().createUserQuery().orderByUserFirstName().asc()).list()) {
                assigneeComboBox.addItem((Object)user.getId());
                assigneeComboBox.setItemCaption((Object)user.getId(), user.getFirstName() + " " + user.getLastName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (taskAssignee != null) {
            assigneeComboBox.select((Object)taskAssignee);
        }
        newItem.getItemProperty((Object)ID_ASSIGNEE).setValue((Object)assigneeComboBox);
        ComboBox groupComboBox = new ComboBox();
        groupComboBox.setNullSelectionAllowed(true);
        try {
            for (Group group : ((GroupQuery)ProcessEngines.getDefaultProcessEngine().getIdentityService().createGroupQuery().orderByGroupName().asc()).list()) {
                groupComboBox.addItem((Object)group.getId());
                groupComboBox.setItemCaption((Object)group.getId(), group.getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (taskGroups != null) {
            groupComboBox.select((Object)taskGroups);
        }
        newItem.getItemProperty((Object)ID_GROUPS).setValue((Object)groupComboBox);
        TextField descriptionTextField = new TextField();
        descriptionTextField.setColumns(16);
        descriptionTextField.setRows(1);
        if (taskDescription != null) {
            descriptionTextField.setValue((Object)taskDescription);
        }
        newItem.getItemProperty((Object)ID_DESCRIPTION).setValue((Object)descriptionTextField);
        CheckBox startWithPreviousCheckBox = new CheckBox(this.i18nManager.getMessage("process.editor.task.startwithprevious"));
        startWithPreviousCheckBox.setValue((Object)(startWithPrevious == null ? false : startWithPrevious));
        newItem.getItemProperty((Object)ID_START_WITH_PREVIOUS).setValue((Object)startWithPreviousCheckBox);
        newItem.getItemProperty((Object)ID_ACTIONS).setValue((Object)this.generateActionButtons(newItemId));
        return newItemId;
    }

    protected HorizontalLayout generateActionButtons(Object taskItemId) {
        HorizontalLayout actionButtons = new HorizontalLayout();
        FormDefinition form = this.taskFormModel.getForm(taskItemId);
        Button formButton = new Button(form == null ? this.i18nManager.getMessage("process.editor.task.form.create") : this.i18nManager.getMessage("process.editor.task.form.edit"));
        formButton.addListener((Button.ClickListener)new ShowFormClickListener(this.taskFormModel, taskItemId));
        formButton.setData(taskItemId);
        actionButtons.addComponent((Component)formButton);
        Button deleteTaskButton = new Button("-");
        deleteTaskButton.setData(taskItemId);
        deleteTaskButton.addListener((Button.ClickListener)new DeleteTaskClickListener(this));
        actionButtons.addComponent((Component)deleteTaskButton);
        Button addTaskButton = new Button("+");
        addTaskButton.setData(taskItemId);
        addTaskButton.addListener((Button.ClickListener)new AddTaskClickListener(this));
        actionButtons.addComponent((Component)addTaskButton);
        return actionButtons;
    }

    public List<HumanStepDefinition> getSteps() {
        ArrayList<HumanStepDefinition> steps = new ArrayList<HumanStepDefinition>();
        for (Object itemId : this.getItemIds()) {
            String assignee;
            Item item = this.getItem(itemId);
            HumanStepDefinition humanStepDefinition = new HumanStepDefinition();
            String name = (String)item.getItemProperty((Object)ID_NAME).getValue();
            if (name != null && name.length() > 0) {
                humanStepDefinition.setName(name);
            }
            if ((assignee = (String)((ComboBox)item.getItemProperty((Object)ID_ASSIGNEE).getValue()).getValue()) != null && assignee.length() > 0) {
                humanStepDefinition.setAssignee(assignee);
            }
            String groups = (String)((ComboBox)item.getItemProperty((Object)ID_GROUPS).getValue()).getValue();
            ArrayList<String> candidateGroups = new ArrayList<String>();
            if (groups != null && groups.length() > 0) {
                for (String group : groups.split(",")) {
                    candidateGroups.add(group.trim());
                }
            }
            humanStepDefinition.setCandidateGroups(candidateGroups);
            String description = (String)((TextField)item.getItemProperty((Object)ID_DESCRIPTION).getValue()).getValue();
            if (description != null && description.length() > 0) {
                humanStepDefinition.setDescription(description);
            }
            humanStepDefinition.setStartsWithPrevious(((CheckBox)item.getItemProperty((Object)ID_START_WITH_PREVIOUS).getValue()).booleanValue());
            FormDefinition formDefinition = this.taskFormModel.getForm(itemId);
            humanStepDefinition.setForm(formDefinition);
            steps.add(humanStepDefinition);
        }
        return steps;
    }

    @Override
    public void formAdded(Object taskItemId) {
        this.getItem(taskItemId).getItemProperty((Object)ID_ACTIONS).setValue((Object)this.generateActionButtons(taskItemId));
    }

    @Override
    public void formRemoved(Object taskItemId) {
        this.getItem(taskItemId).getItemProperty((Object)ID_ACTIONS).setValue((Object)this.generateActionButtons(taskItemId));
    }
}

