/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import java.io.Serializable;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.explorer.ui.process.ProcessDefinitionFilter;
import org.activiti.explorer.ui.process.ProcessDefinitionListQuery;

public class DefaultProcessDefinitionFilter
implements ProcessDefinitionFilter,
Serializable {
    protected static final String PROPERTY_ID = "id";
    protected static final String PROPERTY_NAME = "name";
    protected static final String PROPERTY_KEY = "key";

    @Override
    public ProcessDefinitionQuery getQuery(RepositoryService repositoryService) {
        return (ProcessDefinitionQuery)((ProcessDefinitionQuery)this.getBaseQuery(repositoryService).orderByProcessDefinitionName().asc()).orderByProcessDefinitionKey().asc();
    }

    @Override
    public ProcessDefinitionQuery getCountQuery(RepositoryService repositoryService) {
        return this.getBaseQuery(repositoryService);
    }

    protected ProcessDefinitionQuery getBaseQuery(RepositoryService repositoryService) {
        return repositoryService.createProcessDefinitionQuery().latestVersion().active();
    }

    @Override
    public ProcessDefinitionListQuery.ProcessDefinitionListItem createItem(ProcessDefinition processDefinition) {
        ProcessDefinitionListQuery.ProcessDefinitionListItem item = new ProcessDefinitionListQuery.ProcessDefinitionListItem();
        item.addItemProperty(PROPERTY_ID, (Property)new ObjectProperty((Object)processDefinition.getId()));
        item.addItemProperty(PROPERTY_NAME, (Property)new ObjectProperty((Object)this.getProcessDisplayName(processDefinition)));
        item.addItemProperty(PROPERTY_KEY, (Property)new ObjectProperty((Object)processDefinition.getKey()));
        return item;
    }

    protected String getProcessDisplayName(ProcessDefinition processDefinition) {
        if (processDefinition.getName() != null) {
            return processDefinition.getName();
        }
        return processDefinition.getKey();
    }
}

