/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.processinstance;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.ManagementPage;
import org.activiti.explorer.ui.management.processinstance.AlfrescoProcessInstanceDetailPanel;
import org.activiti.explorer.ui.management.processinstance.ProcessInstanceListQuery;
import org.activiti.explorer.ui.util.ThemeImageColumnGenerator;

public class ProcessInstancePage
extends ManagementPage {
    private static final long serialVersionUID = 1L;
    protected LazyLoadingContainer processInstanceContainer;
    protected String processInstanceId;

    public ProcessInstancePage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("deployment"));
    }

    public ProcessInstancePage(String processInstanceId) {
        this();
        this.processInstanceId = processInstanceId;
    }

    @Override
    protected void initUi() {
        super.initUi();
        if (this.processInstanceId == null) {
            this.selectElement(0);
        } else {
            this.selectElement(this.processInstanceContainer.getIndexForObjectId(this.processInstanceId));
        }
    }

    @Override
    protected Table createList() {
        final Table table = new Table();
        ProcessInstanceListQuery query = new ProcessInstanceListQuery();
        this.processInstanceContainer = new LazyLoadingContainer(query);
        table.setContainerDataSource((Container)this.processInstanceContainer);
        table.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = table.getItem(event.getProperty().getValue());
                if (item != null) {
                    String processInstanceId = (String)item.getItemProperty((Object)"id").getValue();
                    ProcessInstancePage.this.setDetailComponent((Component)new AlfrescoProcessInstanceDetailPanel(processInstanceId, ProcessInstancePage.this));
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("processinstance", processInstanceId));
                } else {
                    ProcessInstancePage.this.setDetailComponent(null);
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("processinstance"));
                }
            }
        });
        table.addGeneratedColumn((Object)"icon", (Table.ColumnGenerator)new ThemeImageColumnGenerator(Images.PROCESS_22));
        table.setColumnWidth((Object)"icon", 22);
        table.addContainerProperty((Object)"name", String.class, null);
        table.setColumnHeaderMode(-1);
        return table;
    }
}

