/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.event.MouseEvents;
import com.vaadin.ui.Button;
import com.vaadin.ui.Embedded;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.management.identity.DeleteMembershipListener;
import org.activiti.explorer.ui.management.identity.UserDetailPanel;

public class GroupsForUserQuery
extends AbstractLazyLoadingQuery {
    protected transient IdentityService identityService;
    protected String userId;
    protected UserDetailPanel userDetailPanel;

    public GroupsForUserQuery(IdentityService identityService, UserDetailPanel userDetailPanel, String userId) {
        this.identityService = identityService;
        this.userDetailPanel = userDetailPanel;
        this.userId = userId;
    }

    @Override
    public int size() {
        return (int)this.identityService.createGroupQuery().groupMember(this.userId).count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List groups = ((GroupQuery)((GroupQuery)((GroupQuery)this.identityService.createGroupQuery().groupMember(this.userId).orderByGroupType().asc()).orderByGroupId().asc()).orderByGroupName().asc()).list();
        ArrayList<Item> groupItems = new ArrayList<Item>();
        for (Group group : groups) {
            groupItems.add((Item)new GroupItem(group));
        }
        return groupItems;
    }

    @Override
    public Item loadSingleResult(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    class GroupItem
    extends PropertysetItem {
        private static final long serialVersionUID = 1L;

        public GroupItem(final Group group) {
            Button idButton = new Button(group.getId());
            idButton.addStyleName("link");
            idButton.addListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    ExplorerApp.get().getViewManager().showGroupPage(group.getId());
                }
            });
            this.addItemProperty("id", (Property)new ObjectProperty((Object)idButton, Button.class));
            if (group.getName() != null) {
                this.addItemProperty("name", (Property)new ObjectProperty((Object)group.getName(), String.class));
            }
            if (group.getType() != null) {
                this.addItemProperty("type", (Property)new ObjectProperty((Object)group.getType(), String.class));
            }
            Embedded deleteIcon = new Embedded(null, Images.DELETE);
            deleteIcon.addStyleName("clickable");
            deleteIcon.addListener((MouseEvents.ClickListener)new DeleteMembershipListener(GroupsForUserQuery.this.identityService, GroupsForUserQuery.this.userId, group.getId(), GroupsForUserQuery.this.userDetailPanel));
            this.addItemProperty("actions", (Property)new ObjectProperty((Object)deleteIcon, Embedded.class));
        }
    }
}

