/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.explorer.ui.custom.ToolbarEntry;
import org.activiti.explorer.ui.custom.ToolbarPopupEntry;

public class ToolBar
extends HorizontalLayout {
    private static final long serialVersionUID = 7957488256766569264L;
    protected Map<String, ToolbarEntry> entryMap = new HashMap<String, ToolbarEntry>();
    protected String currentEntryKey;
    protected ToolbarEntry currentEntry;
    protected List<Button> actionButtons = new ArrayList<Button>();
    protected List<Component> additionalComponents = new ArrayList<Component>();

    public ToolBar() {
        this.setWidth("100%");
        this.setHeight(36.0f, 0);
        this.addStyleName("toolbar");
        this.setSpacing(true);
        this.setMargin(false, true, false, true);
        Label spacer = new Label();
        spacer.setContentMode(3);
        spacer.setValue((Object)"&nbsp;");
        this.addComponent((Component)spacer);
        this.setExpandRatio((Component)spacer, 1.0f);
    }

    public ToolbarEntry addToolbarEntry(String key, String title, ToolbarEntry.ToolbarCommand command) {
        if (this.entryMap.containsKey(key)) {
            throw new IllegalArgumentException("Toolbar already contains entry for key: " + key);
        }
        ToolbarEntry entry = new ToolbarEntry(key, title);
        if (command != null) {
            entry.setCommand(command);
        }
        this.entryMap.put(key, entry);
        this.addEntryComponent(entry);
        return entry;
    }

    public ToolbarPopupEntry addPopupEntry(String key, String title) {
        if (this.entryMap.containsKey(key)) {
            throw new IllegalArgumentException("Toolbar already contains entry for key: " + key);
        }
        ToolbarPopupEntry entry = new ToolbarPopupEntry(key, title);
        this.entryMap.put(key, entry);
        this.addEntryComponent(entry);
        return entry;
    }

    public void addButton(Button button) {
        button.addStyleName("toolbar-button");
        this.actionButtons.add(button);
        this.addComponent((Component)button);
        this.setComponentAlignment((Component)button, Alignment.MIDDLE_RIGHT);
    }

    public void removeAllButtons() {
        for (Button b : this.actionButtons) {
            this.removeComponent((Component)b);
        }
    }

    public void addAdditionalComponent(Component component) {
        this.additionalComponents.add(component);
        this.addComponent(component);
    }

    public void removeAllAdditionalComponents() {
        for (Component c : this.additionalComponents) {
            this.removeComponent(c);
        }
    }

    public long getCount(String key) {
        ToolbarEntry toolbarEntry = this.entryMap.get(key);
        if (toolbarEntry == null) {
            throw new IllegalArgumentException("Toolbar doesn't contain an entry for key: " + key);
        }
        return toolbarEntry.getCount();
    }

    public void setCount(String key, Long count) {
        ToolbarEntry toolbarEntry = this.entryMap.get(key);
        if (toolbarEntry == null) {
            throw new IllegalArgumentException("Toolbar doesn't contain an entry for key: " + key);
        }
        toolbarEntry.setCount(count);
    }

    public ToolbarEntry getEntry(String key) {
        return this.entryMap.get(key);
    }

    public synchronized void setActiveEntry(String key) {
        if (this.currentEntry != null) {
            this.currentEntry.setActive(false);
        }
        this.currentEntryKey = key;
        this.currentEntry = this.entryMap.get(key);
        if (this.currentEntry != null) {
            this.currentEntry.setActive(true);
        }
    }

    protected void addEntryComponent(ToolbarEntry entry) {
        this.addComponent((Component)entry, this.getComponentCount() - 1 - this.actionButtons.size());
        this.setComponentAlignment((Component)entry, Alignment.MIDDLE_LEFT);
    }

    public String getCurrentEntryKey() {
        return this.currentEntryKey;
    }
}

