/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.ui.Upload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;
import org.activiti.explorer.ViewManager;
import org.apache.commons.lang3.StringUtils;

public class ImportUploadReceiver
implements Upload.Receiver,
Upload.FinishedListener,
ModelDataJsonConstants {
    private static final long serialVersionUID = 1L;
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected NotificationManager notificationManager = ExplorerApp.get().getNotificationManager();
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();
    protected ByteArrayOutputStream outputStream;
    protected String fileName;
    protected boolean validFile = false;
    protected Model modelData;

    public OutputStream receiveUpload(String filename, String mimeType) {
        this.fileName = filename;
        this.outputStream = new ByteArrayOutputStream();
        return this.outputStream;
    }

    public void uploadFinished(Upload.FinishedEvent event) {
        this.deployUploadedFile();
        if (this.validFile) {
            this.showUploadedDeployment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployUploadedFile() {
        block15: {
            try {
                try {
                    if (this.fileName.endsWith(".bpmn20.xml") || this.fileName.endsWith(".bpmn")) {
                        this.validFile = true;
                        BpmnXMLConverter xmlConverter = new BpmnXMLConverter();
                        XMLInputFactory xif = XMLInputFactory.newInstance();
                        InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(this.outputStream.toByteArray()), "UTF-8");
                        XMLStreamReader xtr = xif.createXMLStreamReader(in);
                        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                        xmlConverter.convertToBpmnModel(xtr);
                        if (bpmnModel.getMainProcess() == null || bpmnModel.getMainProcess().getId() == null) {
                            this.notificationManager.showErrorNotification("model.import.failed", this.i18nManager.getMessage("model.import.invalid.bpmn.explanation"));
                        } else if (bpmnModel.getLocationMap().size() == 0) {
                            this.notificationManager.showErrorNotification("model.import.invalid.bpmndi", this.i18nManager.getMessage("model.import.invalid.bpmndi.explanation"));
                        } else {
                            String processName = null;
                            processName = StringUtils.isNotEmpty((CharSequence)bpmnModel.getMainProcess().getName()) ? bpmnModel.getMainProcess().getName() : bpmnModel.getMainProcess().getId();
                            this.modelData = this.repositoryService.newModel();
                            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                            modelObjectNode.put("name", processName);
                            modelObjectNode.put("revision", 1);
                            this.modelData.setMetaInfo(modelObjectNode.toString());
                            this.modelData.setName(processName);
                            this.repositoryService.saveModel(this.modelData);
                            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
                            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                            this.repositoryService.addModelEditorSource(this.modelData.getId(), editorNode.toString().getBytes("utf-8"));
                        }
                        break block15;
                    }
                    this.notificationManager.showErrorNotification("model.import.invalid.file", this.i18nManager.getMessage("model.import.invalid.file.explanation"));
                }
                catch (Exception e) {
                    String errorMsg = e.getMessage().replace(System.getProperty("line.separator"), "<br/>");
                    this.notificationManager.showErrorNotification("model.import.failed", errorMsg);
                }
            }
            finally {
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        this.notificationManager.showErrorNotification("Server-side error", e.getMessage());
                    }
                }
            }
        }
    }

    protected void showUploadedDeployment() {
        this.viewManager.showEditorProcessDefinitionPage(this.modelData.getId());
    }
}

