/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.common.api;

import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.PaginateRequest;
import org.activiti.rest.common.api.RequestUtil;
import org.restlet.data.Form;

public abstract class AbstractPaginateList {
    public DataResponse paginateList(Form form, PaginateRequest paginateRequest, Query query, String defaultSort, Map<String, QueryProperty> properties) {
        String order;
        String sort;
        Integer size;
        Integer start;
        if (paginateRequest == null) {
            paginateRequest = new PaginateRequest();
        }
        if (paginateRequest.getStart() == null) {
            paginateRequest.setStart(RequestUtil.getInteger(form, "start", 0));
        }
        if (paginateRequest.getSize() == null) {
            paginateRequest.setSize(RequestUtil.getInteger(form, "size", 10));
        }
        if (paginateRequest.getOrder() == null) {
            paginateRequest.setOrder(form.getValues("order"));
        }
        if (paginateRequest.getSort() == null) {
            paginateRequest.setSort(form.getValues("sort"));
        }
        if ((start = paginateRequest.getStart()) == null || start < 0) {
            start = 0;
        }
        if ((size = paginateRequest.getSize()) == null || size < 0) {
            size = 10;
        }
        if ((sort = paginateRequest.getSort()) == null) {
            sort = defaultSort;
        }
        if ((order = paginateRequest.getOrder()) == null) {
            order = "asc";
        }
        if (sort != null && properties.size() > 0) {
            QueryProperty qp = properties.get(sort);
            if (qp == null) {
                throw new ActivitiIllegalArgumentException("Value for param 'sort' is not valid, '" + sort + "' is not a valid property");
            }
            ((AbstractQuery)query).orderBy(qp);
            if (order.equals("asc")) {
                query.asc();
            } else if (order.equals("desc")) {
                query.desc();
            } else {
                throw new ActivitiIllegalArgumentException("Value for param 'order' is not valid : '" + order + "', must be 'asc' or 'desc'");
            }
        }
        List list = this.processList(query.listPage(start.intValue(), size.intValue()));
        DataResponse response = new DataResponse();
        response.setStart(start);
        response.setSize(list.size());
        response.setSort(sort);
        response.setOrder(order);
        response.setTotal(query.count());
        response.setData(list);
        return response;
    }

    public DataResponse paginateList(Form form, Query query, String defaultSort, Map<String, QueryProperty> properties) {
        return this.paginateList(form, null, query, defaultSort, properties);
    }

    protected abstract List processList(List var1);
}

