/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.yaml.masterslave;

import com.google.common.base.Strings;
import io.shardingsphere.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithm;
import io.shardingsphere.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.exception.ShardingConfigurationException;
import java.util.ArrayList;
import java.util.Collection;

public class YamlMasterSlaveRuleConfiguration {
    private String name;
    private String masterDataSourceName;
    private Collection<String> slaveDataSourceNames = new ArrayList<String>();
    private MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType;
    private String loadBalanceAlgorithmClassName;

    public YamlMasterSlaveRuleConfiguration(MasterSlaveRuleConfiguration masterSlaveRuleConfiguration) {
        this.name = masterSlaveRuleConfiguration.getName();
        this.masterDataSourceName = masterSlaveRuleConfiguration.getMasterDataSourceName();
        this.slaveDataSourceNames = masterSlaveRuleConfiguration.getSlaveDataSourceNames();
        this.loadBalanceAlgorithmClassName = null == masterSlaveRuleConfiguration.getLoadBalanceAlgorithm() ? null : masterSlaveRuleConfiguration.getLoadBalanceAlgorithm().getClass().getName();
    }

    public MasterSlaveRuleConfiguration getMasterSlaveRuleConfiguration() {
        MasterSlaveLoadBalanceAlgorithm loadBalanceAlgorithm = null;
        if (!Strings.isNullOrEmpty((String)this.loadBalanceAlgorithmClassName)) {
            loadBalanceAlgorithm = this.newInstance(this.loadBalanceAlgorithmClassName);
        } else if (null != this.loadBalanceAlgorithmType) {
            loadBalanceAlgorithm = this.loadBalanceAlgorithmType.getAlgorithm();
        }
        return new MasterSlaveRuleConfiguration(this.name, this.masterDataSourceName, this.slaveDataSourceNames, loadBalanceAlgorithm);
    }

    private MasterSlaveLoadBalanceAlgorithm newInstance(String masterSlaveLoadBalanceAlgorithmClassName) {
        try {
            Class<?> result = Class.forName(masterSlaveLoadBalanceAlgorithmClassName);
            if (!MasterSlaveLoadBalanceAlgorithm.class.isAssignableFrom(result)) {
                throw new ShardingConfigurationException("Class %s should be implement %s", masterSlaveLoadBalanceAlgorithmClassName, MasterSlaveLoadBalanceAlgorithm.class.getName());
            }
            return (MasterSlaveLoadBalanceAlgorithm)result.newInstance();
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingConfigurationException("Class %s should have public privilege and no argument constructor", masterSlaveLoadBalanceAlgorithmClassName);
        }
    }

    public YamlMasterSlaveRuleConfiguration() {
    }

    public String getName() {
        return this.name;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public Collection<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    public MasterSlaveLoadBalanceAlgorithmType getLoadBalanceAlgorithmType() {
        return this.loadBalanceAlgorithmType;
    }

    public String getLoadBalanceAlgorithmClassName() {
        return this.loadBalanceAlgorithmClassName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMasterDataSourceName(String masterDataSourceName) {
        this.masterDataSourceName = masterDataSourceName;
    }

    public void setSlaveDataSourceNames(Collection<String> slaveDataSourceNames) {
        this.slaveDataSourceNames = slaveDataSourceNames;
    }

    public void setLoadBalanceAlgorithmType(MasterSlaveLoadBalanceAlgorithmType loadBalanceAlgorithmType) {
        this.loadBalanceAlgorithmType = loadBalanceAlgorithmType;
    }

    public void setLoadBalanceAlgorithmClassName(String loadBalanceAlgorithmClassName) {
        this.loadBalanceAlgorithmClassName = loadBalanceAlgorithmClassName;
    }
}

