/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.util;

import com.google.common.base.CharMatcher;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;

public final class SQLUtil {
    public static String getExactlyValue(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)"[]`'\"").removeFrom((CharSequence)value);
    }

    public static String getExactlyExpression(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)" ").removeFrom((CharSequence)value);
    }

    public static String getOriginalValue(String value, DatabaseType databaseType) {
        if (DatabaseType.MySQL != databaseType) {
            return value;
        }
        try {
            DefaultKeyword.valueOf(value.toUpperCase());
            return String.format("`%s`", value);
        }
        catch (IllegalArgumentException ex) {
            return SQLUtil.getOriginalValueForMySQLKeyword(value);
        }
    }

    private static String getOriginalValueForMySQLKeyword(String value) {
        try {
            MySQLKeyword.valueOf(value.toUpperCase());
            return String.format("`%s`", value);
        }
        catch (IllegalArgumentException ex) {
            return value;
        }
    }

    public static String getNameWithoutSchema(String value) {
        return value.contains(Symbol.DOT.getLiterals()) ? value.substring(value.lastIndexOf(Symbol.DOT.getLiterals()) + Symbol.DOT.getLiterals().length()) : value;
    }

    private SQLUtil() {
    }
}

