/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.sqlserver.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.parser.clause.WhereClauseParser;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import java.util.List;

public final class SQLServerWhereClauseParser
extends WhereClauseParser {
    public SQLServerWhereClauseParser(LexerEngine lexerEngine) {
        super(DatabaseType.SQLServer, lexerEngine);
    }

    @Override
    protected boolean isRowNumberCondition(List<SelectItem> items, String columnLabel) {
        Optional<String> rowNumberAlias = Optional.absent();
        for (SelectItem each : items) {
            if (!each.getAlias().isPresent() || !"ROW_NUMBER".equalsIgnoreCase(each.getExpression())) continue;
            rowNumberAlias = each.getAlias();
            break;
        }
        return columnLabel.equalsIgnoreCase((String)rowNumberAlias.orNull());
    }

    @Override
    protected Keyword[] getCustomizedOtherConditionOperators() {
        return new Keyword[0];
    }
}

