/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.sql.statement.tcl;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.sql.AbstractSQLStatement;
import java.util.Arrays;
import java.util.Collection;

public class TCLStatement
extends AbstractSQLStatement {
    private static final Collection<Keyword> STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.COMMIT, DefaultKeyword.ROLLBACK, DefaultKeyword.SAVEPOINT, DefaultKeyword.BEGIN);

    public TCLStatement() {
        super(SQLType.TCL);
    }

    public static boolean isTCL(TokenType tokenType) {
        return STATEMENT_PREFIX.contains(tokenType);
    }

    public static boolean isTCLUnsafe(DatabaseType databaseType, TokenType tokenType, LexerEngine lexerEngine) {
        if (DefaultKeyword.SET.equals(tokenType) || DatabaseType.SQLServer.equals((Object)databaseType) && DefaultKeyword.IF.equals(tokenType)) {
            lexerEngine.skipUntil(DefaultKeyword.TRANSACTION, DefaultKeyword.AUTOCOMMIT, DefaultKeyword.IMPLICIT_TRANSACTIONS);
            if (!lexerEngine.isEnd()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "TCLStatement(super=" + super.toString() + ")";
    }
}

