/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.parser.advanced;

import java.beans.ConstructorProperties;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.misc.IntervalSet;

public final class AdvancedErrorStrategy
extends DefaultErrorStrategy {
    private final int identifierTokenIndex;

    public void sync(Parser recognizer) throws RecognitionException {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        try {
            TokenStream tokens = recognizer.getInputStream();
            Token token = tokens.LT(1);
            ATNState state = (ATNState)((ParserATNSimulator)recognizer.getInterpreter()).atn.states.get(recognizer.getState());
            IntervalSet nextTokens = recognizer.getATN().nextTokens(state);
            if (nextTokens.contains(token.getType())) {
                this.nextTokensContext = null;
                this.nextTokensState = -1;
                return;
            }
            if (nextTokens.contains(-2)) {
                if (null == this.nextTokensContext) {
                    this.nextTokensContext = recognizer.getContext();
                    this.nextTokensState = recognizer.getState();
                }
                return;
            }
            if (nextTokens.contains(this.identifierTokenIndex)) {
                ((CommonToken)token).setType(this.identifierTokenIndex);
            }
            super.sync(recognizer);
        }
        catch (InputMismatchException ex) {
            this.tryToExecuteByID(recognizer, ex);
        }
    }

    private void tryToExecuteByID(Parser recognizer, InputMismatchException cause) {
        Token token = cause.getOffendingToken();
        if (!(token instanceof CommonToken)) {
            throw cause;
        }
        CommonToken commonToken = (CommonToken)token;
        int previousType = commonToken.getType();
        if (previousType > this.identifierTokenIndex) {
            return;
        }
        commonToken.setType(this.identifierTokenIndex);
        try {
            super.sync(recognizer);
        }
        catch (InputMismatchException ex) {
            if (cause.getOffendingToken() == ex.getOffendingToken()) {
                commonToken.setType(previousType);
                throw cause;
            }
            this.tryToExecuteByID(recognizer, ex);
        }
        catch (Exception ex) {
            commonToken.setType(previousType);
            throw cause;
        }
    }

    @ConstructorProperties(value={"identifierTokenIndex"})
    public AdvancedErrorStrategy(int identifierTokenIndex) {
        this.identifierTokenIndex = identifierTokenIndex;
    }
}

