/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.optimizer;

import io.shardingsphere.core.optimizer.OptimizeEngine;
import io.shardingsphere.core.optimizer.insert.InsertOptimizeEngine;
import io.shardingsphere.core.optimizer.query.QueryOptimizeEngine;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.DMLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.List;

public final class OptimizeEngineFactory {
    public static OptimizeEngine newInstance(ShardingRule shardingRule, SQLStatement sqlStatement, List<Object> parameters, GeneratedKey generatedKey) {
        if (sqlStatement instanceof InsertStatement) {
            return new InsertOptimizeEngine(shardingRule, (InsertStatement)sqlStatement, parameters, generatedKey);
        }
        if (sqlStatement instanceof SelectStatement || sqlStatement instanceof DMLStatement) {
            return new QueryOptimizeEngine(sqlStatement.getConditions().getOrCondition(), parameters);
        }
        return new QueryOptimizeEngine(sqlStatement.getConditions().getOrCondition(), parameters);
    }

    private OptimizeEngineFactory() {
    }
}

