/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

public class COSObjectWrapper
implements Closeable {
    private final COSObject cosobj;
    private final COSObjectId id;

    COSObjectWrapper(COSObject cosobj, COSObjectId id) {
        if (cosobj == null) {
            throw new IllegalArgumentException();
        }
        this.cosobj = cosobj;
        this.id = id;
    }

    public COSObjectId getCOSObjectId() {
        return this.id;
    }

    ObjectMetadata getObjectMetadata() {
        return this.cosobj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata metadata) {
        this.cosobj.setObjectMetadata(metadata);
    }

    COSObjectInputStream getObjectContent() {
        return this.cosobj.getObjectContent();
    }

    void setObjectContent(COSObjectInputStream objectContent) {
        this.cosobj.setObjectContent(objectContent);
    }

    void setObjectContent(InputStream objectContent) {
        this.cosobj.setObjectContent(objectContent);
    }

    String getBucketName() {
        return this.cosobj.getBucketName();
    }

    void setBucketName(String bucketName) {
        this.cosobj.setBucketName(bucketName);
    }

    String getKey() {
        return this.cosobj.getKey();
    }

    void setKey(String key) {
        this.cosobj.setKey(key);
    }

    public String toString() {
        return this.cosobj.toString();
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata metadata = this.cosobj.getObjectMetadata();
        Map<String, String> userMeta = metadata.getUserMetadata();
        return userMeta != null && userMeta.containsKey("x-cos-iv") && (userMeta.containsKey("x-cos-key-v2") || userMeta.containsKey("x-cos-key"));
    }

    String toJsonString() {
        try {
            return COSObjectWrapper.from(this.cosobj.getObjectContent());
        }
        catch (Exception e) {
            throw new CosClientException("Error parsing JSON: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StringUtils.UTF8));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.cosobj.close();
    }

    COSObject getCOSObject() {
        return this.cosobj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> instructionFile) {
        if (instructionFile != null) {
            String cekAlgo = instructionFile.get("x-cos-cek-alg");
            return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
        }
        ObjectMetadata meta = this.cosobj.getObjectMetadata();
        Map<String, String> userMeta = meta.getUserMetadata();
        String cekAlgo = userMeta.get("x-cos-cek-alg");
        return ContentCryptoScheme.fromCEKAlgo(cekAlgo);
    }
}

