/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.internal.InputSubstream;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerUtils;
import java.io.File;

public class UploadPartRequestFactory {
    private final String bucketName;
    private final String key;
    private final String uploadId;
    private final long optimalPartSize;
    private final File file;
    private final PutObjectRequest origReq;
    private int partNumber = 1;
    private long offset = 0L;
    private long remainingBytes;
    private SSECustomerKey sseCustomerKey;
    private final int totalNumberOfParts;
    private ReleasableInputStream wrappedStream;

    public UploadPartRequestFactory(PutObjectRequest origReq, String uploadId, long optimalPartSize) {
        this.origReq = origReq;
        this.uploadId = uploadId;
        this.optimalPartSize = optimalPartSize;
        this.bucketName = origReq.getBucketName();
        this.key = origReq.getKey();
        this.file = TransferManagerUtils.getRequestFile(origReq);
        this.remainingBytes = TransferManagerUtils.getContentLength(origReq);
        this.sseCustomerKey = origReq.getSSECustomerKey();
        this.totalNumberOfParts = (int)Math.ceil((double)this.remainingBytes / (double)this.optimalPartSize);
        if (origReq.getInputStream() != null) {
            this.wrappedStream = ReleasableInputStream.wrap(origReq.getInputStream());
        }
    }

    public synchronized boolean hasMoreRequests() {
        return this.remainingBytes > 0L;
    }

    public synchronized UploadPartRequest getNextUploadPartRequest() {
        long partSize = Math.min(this.optimalPartSize, this.remainingBytes);
        boolean isLastPart = this.remainingBytes - partSize <= 0L;
        UploadPartRequest req = null;
        req = this.wrappedStream != null ? new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withInputStream(new InputSubstream(this.wrappedStream, 0L, partSize, isLastPart)).withPartNumber(this.partNumber++).withPartSize(partSize) : new UploadPartRequest().withBucketName(this.bucketName).withKey(this.key).withUploadId(this.uploadId).withFile(this.file).withFileOffset(this.offset).withPartNumber(this.partNumber++).withPartSize(partSize);
        TransferManager.appendMultipartUserAgent(req);
        if (this.sseCustomerKey != null) {
            req.setSSECustomerKey(this.sseCustomerKey);
        }
        this.offset += partSize;
        this.remainingBytes -= partSize;
        req.setLastPart(isLastPart);
        req.withGeneralProgressListener(this.origReq.getGeneralProgressListener());
        req.getRequestClientOptions().setReadLimit(this.origReq.getReadLimit());
        return req;
    }

    public int getTotalNumberOfParts() {
        return this.totalNumberOfParts;
    }
}

