/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import jetbrick.template.runtime.JetWriter;

public final class JetOutputStreamPrinterEx
extends JetWriter {
    private final OutputStream os;
    private final Charset charset;

    public JetOutputStreamPrinterEx(OutputStream os, Charset charset) {
        this.os = os;
        this.charset = charset;
    }

    @Override
    public Object getOriginStream() {
        return this.os;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean isSkipErrors() {
        return false;
    }

    @Override
    public void print(int x) throws IOException {
        this.os.write(x);
    }

    @Override
    public void print(byte[] x) throws IOException {
        if (x != null) {
            this.os.write(x);
        }
    }

    @Override
    public void print(byte[] x, int offset, int length) throws IOException {
        if (x != null) {
            this.os.write(x, offset, length);
        }
    }

    @Override
    public void print(char[] x) throws IOException {
        if (x != null) {
            this.os.write(new String(x).getBytes(this.charset));
        }
    }

    @Override
    public void print(char[] x, int offset, int length) throws IOException {
        if (x != null) {
            this.os.write(new String(x, offset, length).getBytes(this.charset));
        }
    }

    @Override
    public void print(String x) throws IOException {
        if (x != null) {
            this.os.write(x.getBytes(this.charset));
        }
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

