/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime.buildin;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jetbrick.util.DateUtils;
import jetbrick.util.IdentifiedNameUtils;
import jetbrick.util.JSONUtils;
import jetbrick.util.StringEscapeUtils;
import jetbrick.util.StringUtils;

public final class JetMethods {
    public static Boolean asBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if ("true".equals(value = value.toString().toLowerCase())) {
            return Boolean.TRUE;
        }
        if ("yes".equals(value)) {
            return Boolean.TRUE;
        }
        if ("on".equals(value)) {
            return Boolean.TRUE;
        }
        if ("t".equals(value)) {
            return Boolean.TRUE;
        }
        if ("y".equals(value)) {
            return Boolean.TRUE;
        }
        if ("1".equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Integer asInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static Long asLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.valueOf(value.toString());
    }

    public static Float asFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return Float.valueOf(value.toString());
    }

    public static Double asDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.valueOf(value.toString());
    }

    public static Date asDate(String value) {
        return DateUtils.parse((String)value);
    }

    public static Date asDate(String value, String format) {
        return DateUtils.parse((String)value, (String)format);
    }

    public static <T> List<T> asList(Collection<T> values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            return (List)values;
        }
        return new ArrayList<T>(values);
    }

    public static List<Object> asList(Object[] values) {
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(values.length);
        for (Object value : values) {
            list.add(value);
        }
        return list;
    }

    public static String asString(Object value) {
        return value.toString();
    }

    public static String asJson(Object object) {
        return JSONUtils.toJSONString((Object)object);
    }

    public static String format(Number value) {
        return JetMethods.format(value, "###,##0.00");
    }

    public static String format(Number value, String format) {
        return new DecimalFormat(format).format(value);
    }

    public static String format(Date value) {
        return DateUtils.format((Date)value, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date value, String format) {
        return DateUtils.format((Date)value, (String)format);
    }

    public static String capitalize(String s) {
        return IdentifiedNameUtils.capitalize((String)s);
    }

    public static String toUnderlineName(String s) {
        return IdentifiedNameUtils.toUnderlineName((String)s);
    }

    public static String toCamelCase(String s) {
        return IdentifiedNameUtils.toCamelCase((String)s);
    }

    public static String toCapitalizeCamelCase(String s) {
        return IdentifiedNameUtils.toCapitalizeCamelCase((String)s);
    }

    public static String deleteWhitespace(String s) {
        return StringUtils.deleteWhitespace((String)s);
    }

    public static String repeat(String s, String separator, int repeat) {
        return StringUtils.repeat((String)s, (String)separator, (int)repeat);
    }

    public static String repeat(String s, int repeat) {
        return JetMethods.repeat(s, "", repeat);
    }

    public static String abbreviate(String str, int maxWidth) {
        return JetMethods.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        String abrevMarker = "...";
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + maxWidth - 3 < str.length()) {
            return "..." + JetMethods.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String md5Hex(String s) {
        return JetMethods.md5Hex(s, "UTF-8");
    }

    public static String md5Hex(String s, String charsetName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(s.getBytes(charsetName));
            byte[] digest = md.digest();
            BigInteger bigInteger = new BigInteger(1, digest);
            return bigInteger.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String sha1Hex(String s) {
        return JetMethods.sha1Hex(s, "UTF-8");
    }

    public static String sha1Hex(String s, String charsetName) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.reset();
            md.update(s.getBytes(charsetName));
            byte[] digest = md.digest();
            BigInteger bigInteger = new BigInteger(1, digest);
            return bigInteger.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String escapeJava(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    public static String unescapeJava(String value) {
        return StringEscapeUtils.unescapeJava((String)value);
    }

    public static String escapeJavaScript(String value) {
        return StringEscapeUtils.escapeJavaScript((String)value);
    }

    public static String unescapeJavaScript(String value) {
        return StringEscapeUtils.unescapeJavaScript((String)value);
    }

    public static String escapeXml(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    public static String unescapeXml(String value) {
        return StringEscapeUtils.unescapeXml((String)value);
    }

    public static String escapeUrl(String value) {
        return StringEscapeUtils.escapeUrl((String)value);
    }

    public static String escapeUrl(String value, String encoding) {
        return StringEscapeUtils.escapeUrl((String)value, (String)encoding);
    }

    public static String unescapeUrl(String value) {
        return StringEscapeUtils.unescapeUrl((String)value);
    }

    public static String unescapeUrl(String value, String encoding) {
        return StringEscapeUtils.unescapeUrl((String)value, (String)encoding);
    }
}

