/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.resolver.method;

import jetbrick.bean.MethodInfo;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.resolver.method.MethodInvoker;

final class ClassBuildinMethodInvoker
implements MethodInvoker {
    private final MethodInfo method;
    private final int length;
    private final Class<?> varArgsClass;

    public ClassBuildinMethodInvoker(MethodInfo method) {
        this.method = method;
        this.length = method.getParameterCount();
        if (method.isVarArgs()) {
            Class[] types = method.getParameterTypes();
            this.varArgsClass = types[types.length - 1].getComponentType();
        } else {
            this.varArgsClass = null;
        }
    }

    @Override
    public void checkAccess(JetSecurityManager securityManager) {
        securityManager.checkAccess(this.method.getMethod());
    }

    @Override
    public Object invoke(Object object, Object[] arguments) {
        arguments = ParameterUtils.getActualArguments(arguments, this.length, this.varArgsClass, 0);
        return this.method.invoke(object, arguments);
    }

    @Override
    public boolean isVoidResult() {
        return this.method.getReturnType() == Void.TYPE;
    }

    @Override
    public String getSignature() {
        return this.method.getSignature();
    }
}

