/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.bean.ConstructorInfo;
import jetbrick.bean.KlassInfo;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.AstExpressionList;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.util.ArrayUtils;

public final class AstInvokeNewObject
extends AstExpression {
    private final Class<?> type;
    private final AstExpressionList argumentList;
    private boolean unsafe;

    public AstInvokeNewObject(Class<?> type, AstExpressionList argumentList, Position position) {
        super(position);
        this.type = type;
        this.argumentList = argumentList;
        this.unsafe = true;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object[] arguments = this.argumentList == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : this.argumentList.execute(ctx);
        int length = arguments.length;
        Class[] parameterTypes = new Class[length];
        for (int i = 0; i < length; ++i) {
            Object arg = arguments[i];
            parameterTypes[i] = arg == null ? null : arg.getClass();
        }
        ConstructorInfo constructor = KlassInfo.create(this.type).searchDeclaredConstructor(parameterTypes);
        if (constructor == null) {
            String signature = SignatureUtils.getMethodSignature(this.type, "<init>", parameterTypes);
            throw new InterpretException("cannot resolve constructor: %s", signature).set(this.position);
        }
        if (this.unsafe) {
            JetSecurityManager securityManager = ctx.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccess(constructor.getConstructor());
                }
                catch (RuntimeException e) {
                    throw new InterpretException(e).set(this.position);
                }
            }
            this.unsafe = false;
        }
        try {
            return constructor.newInstance(arguments);
        }
        catch (RuntimeException e) {
            throw new InterpretException("constructor invoke error: %s", this.type.getName()).cause(e).set(this.position);
        }
    }
}

