/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstInvokeIndexGet
extends AstExpression {
    private final AstExpression objectExpression;
    private final AstExpression indexExpression;
    private final boolean nullSafe;

    public AstInvokeIndexGet(AstExpression objectExpression, AstExpression indexExpression, boolean nullSafe, Position position) {
        super(position);
        this.objectExpression = objectExpression;
        this.indexExpression = indexExpression;
        this.nullSafe = nullSafe;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object object = this.objectExpression.execute(ctx);
        if (object == null) {
            if (this.nullSafe || ctx.getTemplate().getOption().isSafecall()) {
                return null;
            }
            throw new InterpretException("object is null").set(this.objectExpression.getPosition());
        }
        if (object == ALU.VOID) {
            throw new InterpretException("object is void").set(this.objectExpression.getPosition());
        }
        Object index = this.indexExpression.execute(ctx);
        if (index == null) {
            throw new InterpretException("index is null").set(this.indexExpression.getPosition());
        }
        if (index == ALU.VOID) {
            throw new InterpretException("index is void").set(this.indexExpression.getPosition());
        }
        Class<?> objectClass = object.getClass();
        Class<?> indexClass = index.getClass();
        if (objectClass.isArray()) {
            if (indexClass == Integer.class) {
                int i = ((Number)index).intValue();
                if (objectClass.getComponentType().isPrimitive()) {
                    return Array.get(object, i);
                }
                return ((Object[])object)[i];
            }
        } else if (List.class.isAssignableFrom(objectClass)) {
            if (indexClass == Integer.class) {
                int i = ((Number)index).intValue();
                return ((List)object).get(i);
            }
        } else if (Map.class.isAssignableFrom(objectClass) && indexClass == String.class) {
            return ((Map)object).get(index);
        }
        throw new InterpretException("the operator `%s` is undefined for the argument type(s): %s, %s", "[]", object.getClass(), index.getClass()).set(this.position);
    }
}

