/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.Errors;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.AstExpressionList;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.function.FunctionInvoker;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.util.ArrayUtils;

public final class AstInvokeFunction
extends AstExpression {
    private final String name;
    private final AstExpressionList argumentList;
    private FunctionInvoker last;
    private boolean unsafe;

    public AstInvokeFunction(String name, AstExpressionList argumentList, Position position) {
        super(position);
        this.name = name;
        this.argumentList = argumentList;
        this.last = null;
        this.unsafe = true;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object[] arguments = this.argumentList == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : this.argumentList.execute(ctx);
        return this.doInvoke(ctx, this.last, arguments);
    }

    private Object doInvoke(InterpretContext ctx, FunctionInvoker fn, Object[] arguments) throws InterpretException {
        boolean useLatest;
        boolean bl = useLatest = fn != null;
        if (fn == null) {
            Class<?>[] argumentTypes = ParameterUtils.getParameterTypes(arguments);
            fn = ctx.getGlobalResolver().resolveFunction(this.name, argumentTypes);
            if (fn == null) {
                String signature = SignatureUtils.getFunctionSignature(this.name, argumentTypes);
                throw new InterpretException("cannot resolve function: %s", signature).set(this.position);
            }
            this.last = fn;
        }
        if (this.unsafe) {
            JetSecurityManager securityManager = ctx.getSecurityManager();
            if (securityManager != null) {
                try {
                    fn.checkAccess(securityManager);
                }
                catch (RuntimeException e) {
                    throw new InterpretException(e).set(this.position);
                }
            }
            this.unsafe = false;
        }
        try {
            return fn.invoke(arguments);
        }
        catch (InterpretException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (useLatest && Errors.isReflectIllegalArgument(e)) {
                return this.doInvoke(ctx, null, arguments);
            }
            throw new InterpretException("function invoke error: %s", fn.getSignature()).cause(e).set(this.position);
        }
    }
}

