/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.bean.FieldInfo;
import jetbrick.bean.KlassInfo;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstInvokeFieldStatic
extends AstExpression {
    private final Class<?> cls;
    private final String name;
    private FieldInfo field;
    private boolean unsafe;

    public AstInvokeFieldStatic(Class<?> cls, String name, Position position) {
        super(position);
        this.cls = cls;
        this.name = name;
        this.field = null;
        this.unsafe = true;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        if (this.field == null) {
            if ("class".equals(this.name)) {
                return this.cls;
            }
            this.field = KlassInfo.create(this.cls).getDeclaredField(this.name);
            if (this.field == null) {
                String signature = SignatureUtils.getFieldSignature(this.cls, this.name);
                throw new InterpretException("cannot resolve static field: %s", signature).set(this.position);
            }
        }
        if (this.unsafe) {
            JetSecurityManager securityManager = ctx.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccess(this.field.getField());
                }
                catch (RuntimeException e) {
                    throw new InterpretException(e).set(this.position);
                }
            }
            this.unsafe = false;
        }
        try {
            return this.field.get(null);
        }
        catch (Exception e) {
            throw new InterpretException("static field get error: %s#%s", this.cls.getName(), this.name).cause(e).set(this.position);
        }
    }
}

