/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import java.util.List;
import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstExpressionList
extends AstExpression {
    private static final AstExpression[] EMPTY_ARRAY = new AstExpression[0];
    private final AstExpression[] expressions;

    public AstExpressionList(List<AstExpression> expressions, Position position) {
        super(position);
        this.expressions = expressions.toArray(EMPTY_ARRAY);
    }

    public Object[] execute(InterpretContext ctx) {
        int length = this.expressions.length;
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object obj = this.expressions[i].execute(ctx);
            if (obj == ALU.VOID) {
                throw new InterpretException("argument is void").set(this.expressions[i].getPosition());
            }
            objects[i] = obj;
        }
        return objects;
    }
}

