/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.parser.ast.AstDirective;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstDirectiveReturn
extends AstDirective {
    private final AstExpression expression;

    public AstDirectiveReturn(AstExpression expression, Position position) {
        super(position);
        this.expression = expression;
    }

    @Override
    public void execute(InterpretContext ctx) throws InterpretException {
        if (this.expression != null) {
            String name = ctx.getReturnName();
            if (name == null) {
                name = "RETURN";
            }
            Object value = this.expression.execute(ctx);
            try {
                ctx.getValueStack().setSuper(name, value);
            }
            catch (IllegalStateException e) {
                throw new InterpretException(e).set(this.expression.getPosition());
            }
        }
        ctx.setSignal(3);
    }
}

