/*
 * Decompiled with CFR 0.152.
 */
package org.nico.noson.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.nico.noson.exception.NosonException;
import org.nico.noson.util.reflect.MethodUtils;
import org.nico.noson.util.type.TypeUtils;

public class FieldUtils {
    public static void set(Field field, Object obj, Class<?> clazz, Object value) throws NosonException {
        Method currentMethod = MethodUtils.getSetterMethod(field, clazz);
        if (currentMethod == null) {
            return;
        }
        try {
            value = TypeUtils.convertType(field.getType(), value);
            MethodUtils.invoke(currentMethod, obj, value);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void set(String fieldName, Object obj, Class<?> clazz, Object value) throws NosonException {
        try {
            Field field = FieldUtils.getField(fieldName, clazz);
            Method currentMethod = MethodUtils.getSetterMethod(field, clazz);
            if (currentMethod == null) {
                return;
            }
            value = TypeUtils.convertType(field.getType(), value);
            MethodUtils.invoke(currentMethod, obj, value);
        }
        catch (Exception e) {
            throw new NosonException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Field field, Object obj, Class<?> clazz) {
        Method currentMethod;
        if (Modifier.isStatic(field.getModifiers())) {
            field.setAccessible(true);
            try {
                Object object = field.get(obj);
                return object;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            finally {
                field.setAccessible(false);
            }
        }
        if ((currentMethod = MethodUtils.getGetterMethod(field, clazz)) == null) {
            return null;
        }
        try {
            return MethodUtils.invoke(currentMethod, obj, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getField(String fieldName, Class<?> clazz) throws NosonException {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                field = FieldUtils.getField(fieldName, clazz.getSuperclass());
            }
            return null;
        }
        return field;
    }
}

