/*
 * Decompiled with CFR 0.152.
 */
package org.nico.noson.scanner.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.nico.noson.entity.TypeBean;
import org.nico.noson.exception.NosonException;
import org.nico.noson.scanner.buddy.JsonFieldParser;
import org.nico.noson.scanner.impl.EmptyScanner;
import org.nico.noson.util.reflect.ClassUtils;
import org.nico.noson.util.type.TypeUtils;

public class SimpleScanner
extends EmptyScanner {
    @Override
    public <T> T scan(String json, Class<T> clazz) throws NosonException {
        List<Class<?>> classItes = TypeUtils.getGenericityTypeIterate(clazz);
        List subClassItes = null;
        int classItesSize = classItes.size();
        Stack<SimpleStruct> structStack = new Stack<SimpleStruct>();
        Stack<List> subClassItesStack = new Stack<List>();
        int subClassItesSumNumber = 0;
        String keyCache = null;
        String valueCache = null;
        ScanState state = ScanState.NORMAL;
        Object result = null;
        boolean preObjectIsUserDefined = false;
        Class<?> preObjectType = null;
        char[] chars = json.toCharArray();
        Object newStruct = null;
        Class newClass = null;
        char c = '\u0000';
        int stackSize = 0;
        block4: for (int index = 0; index < chars.length; ++index) {
            Object value;
            String key;
            SimpleStruct preSimpleStruct;
            SimpleStruct currentSimpleStruct;
            List classItems;
            c = chars[index];
            if (c == '[' || c == '{') {
                stackSize = structStack.size();
                List list = subClassItes = subClassItesStack.isEmpty() ? null : (List)subClassItesStack.peek();
                if (stackSize < classItesSize && !classItes.get(stackSize).getName().equalsIgnoreCase(Object.class.getName())) {
                    newClass = classItes.get(stackSize);
                } else if (stackSize > classItesSize && subClassItes != null && subClassItes.size() > 0 && stackSize - (subClassItesSumNumber - subClassItes.size()) - classItesSize < subClassItes.size()) {
                    int subIndex = stackSize - (subClassItesSumNumber - subClassItes.size()) - classItesSize;
                    newClass = (Class)subClassItes.get(subIndex);
                } else if (preObjectIsUserDefined) {
                    TypeBean<?> typeBean = TypeUtils.getFieldType(preObjectType, TypeUtils.typeAllotKey(keyCache));
                    newClass = typeBean.getMainClass();
                    if (typeBean.getGenericityBeans() != null && typeBean.getGenericityBeans().length > 0) {
                        classItems = TypeUtils.getGenericityTypeIterate(typeBean);
                        subClassItesStack.push(classItems);
                        subClassItesSumNumber += classItems == null ? 0 : classItems.size();
                    } else {
                        subClassItesStack.push(null);
                    }
                } else if (c == '[') {
                    newClass = Collection.class;
                } else if (c == '{') {
                    newClass = Map.class;
                }
                newStruct = TypeUtils.getStructInstance(newClass);
                currentSimpleStruct = new SimpleStruct(TypeUtils.typeAllotKey(keyCache), newStruct, newClass);
                if (currentSimpleStruct.getStructType() == SimpleStruct.StructType.PARAM) {
                    preSimpleStruct = (SimpleStruct)structStack.peek();
                    TypeUtils.setParamIntoObject(preSimpleStruct.getValue(), currentSimpleStruct);
                } else {
                    structStack.push(currentSimpleStruct);
                }
                preObjectIsUserDefined = currentSimpleStruct.getStructType() == SimpleStruct.StructType.OBJECT;
                preObjectType = currentSimpleStruct.getClassType();
                state = currentSimpleStruct.getState();
                if (result != null) continue;
                result = newStruct;
                continue;
            }
            if (c == ']' || c == '}') {
                currentSimpleStruct = null;
                if (valueCache != null) {
                    currentSimpleStruct = (SimpleStruct)structStack.peek();
                    key = TypeUtils.typeAllotKey(keyCache);
                    value = TypeUtils.typeAllotValue(valueCache);
                    TypeUtils.setParamIntoObject(currentSimpleStruct.getValue(), new SimpleStruct(key, value));
                    valueCache = null;
                }
                currentSimpleStruct = (SimpleStruct)structStack.pop();
                if (!structStack.isEmpty()) {
                    preSimpleStruct = (SimpleStruct)structStack.peek();
                    TypeUtils.setParamIntoObject(preSimpleStruct.getValue(), currentSimpleStruct);
                    currentSimpleStruct = preSimpleStruct;
                }
                preObjectIsUserDefined = currentSimpleStruct.getStructType() == SimpleStruct.StructType.OBJECT;
                preObjectType = currentSimpleStruct.getClassType();
                state = currentSimpleStruct.getState();
                if (!preObjectIsUserDefined || subClassItesStack.isEmpty()) continue;
                classItems = (List)subClassItesStack.pop();
                subClassItesSumNumber -= classItems == null ? 0 : classItems.size();
                continue;
            }
            switch (state) {
                case KEY: {
                    if (c == ',') continue block4;
                    JsonFieldParser.ParserResult parserResult = this.jsonKeyParser.parser(json, index);
                    keyCache = parserResult.getValue();
                    index += parserResult.getLen();
                    state = ScanState.VALUE;
                    continue block4;
                }
                case VALUE: {
                    if (c == ',') {
                        if (valueCache == null) continue block4;
                        currentSimpleStruct = (SimpleStruct)structStack.peek();
                        key = TypeUtils.typeAllotKey(keyCache);
                        value = TypeUtils.typeAllotValue(valueCache);
                        TypeUtils.setParamIntoObject(currentSimpleStruct.getValue(), new SimpleStruct(key, value));
                        valueCache = null;
                        state = currentSimpleStruct.state;
                        continue block4;
                    }
                    JsonFieldParser.ParserResult parserResult = this.jsonValueParser.parser(json, index);
                    valueCache = parserResult.getValue();
                    index += parserResult.getLen() - 1;
                    continue block4;
                }
            }
        }
        return (T)result;
    }

    public static class SimpleStruct {
        private String name;
        private Object value;
        private Class<?> classType;
        private ScanState state;
        private StructType structType;

        public SimpleStruct(String name, Object value) {
            this(name, value, value == null ? null : value.getClass());
        }

        public SimpleStruct(String name, Object value, Class<?> classType) {
            this.name = name;
            if (value == null) {
                this.structType = StructType.PARAM;
                this.state = ScanState.KEY;
            } else {
                this.value = value;
                this.classType = classType;
                if (value instanceof Collection) {
                    this.structType = StructType.COLLECTION;
                    this.state = ScanState.VALUE;
                } else if (value.getClass().isArray()) {
                    this.structType = StructType.ARRAY;
                    this.state = ScanState.VALUE;
                } else if (value instanceof Map) {
                    this.structType = StructType.MAP;
                    this.state = ScanState.KEY;
                } else if (ClassUtils.isJavaClass(classType)) {
                    this.structType = StructType.PARAM;
                    this.state = ScanState.KEY;
                } else {
                    this.structType = StructType.OBJECT;
                    this.state = ScanState.KEY;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public ScanState getState() {
            return this.state;
        }

        public void setState(ScanState state) {
            this.state = state;
        }

        public Class<?> getClassType() {
            return this.classType;
        }

        public void setClassType(Class<?> classType) {
            this.classType = classType;
        }

        public StructType getStructType() {
            return this.structType;
        }

        public void setStructType(StructType structType) {
            this.structType = structType;
        }

        public static enum StructType {
            ARRAY,
            COLLECTION,
            MAP,
            PARAM,
            OBJECT;

        }
    }

    static enum ScanState {
        KEY,
        VALUE,
        NORMAL;

    }
}

