/*
 * Decompiled with CFR 0.152.
 */
package org.nico.noson.cache;

import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.nico.noson.cache.Cache;

public class SimpleCache
implements Cache {
    private Map<Object, Object> mapCache = new ConcurrentHashMap<Object, Object>(100, 0.8f);
    private long delay;

    public SimpleCache(long delay) {
        this.delay = delay;
    }

    public SimpleCache() {
    }

    @Override
    public Object getCache(Object key) {
        return this.mapCache.get(key);
    }

    @Override
    public Object putCache(Object key, Object value) {
        return this.putCache(key, value, this.delay);
    }

    @Override
    public Object putCache(Object key, Object value, long delay) {
        if (value == null) {
            return null;
        }
        if (delay > 0L) {
            // empty if block
        }
        return this.mapCache.put(key, value);
    }

    @Override
    public boolean containsCache(Object key) {
        return this.mapCache.containsKey(key);
    }

    @Override
    public Object removeCache(Object key) {
        return this.mapCache.remove(key);
    }

    @Override
    public Set<Map.Entry<Object, Object>> cacheSet() {
        return this.mapCache.entrySet();
    }

    @Override
    public void clearCache() {
        this.mapCache.clear();
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    class NosonTimer {
        private Timer cacheTimer = new Timer();

        public void addCacheTask(final Object key, final Cache cache, long delay) {
            TimerTask task = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cache cache2 = cache;
                    synchronized (cache2) {
                        cache.removeCache(key);
                    }
                }
            };
            this.cacheTimer.schedule(task, delay);
        }

        public void cancel() {
            this.cacheTimer.cancel();
        }
    }
}

