/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.schedule;

import com.dangdang.ddframe.job.exception.JobSystemException;
import java.beans.ConstructorProperties;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public final class JobScheduleController {
    private final Scheduler scheduler;
    private final JobDetail jobDetail;
    private final String triggerIdentity;

    public void scheduleJob(String cron) {
        try {
            if (!this.scheduler.checkExists(this.jobDetail.getKey())) {
                this.scheduler.scheduleJob(this.jobDetail, (Trigger)this.createTrigger(cron));
            }
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void rescheduleJob(String cron) {
        try {
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(TriggerKey.triggerKey((String)this.triggerIdentity));
            if (!this.scheduler.isShutdown() && null != trigger && !cron.equals(trigger.getCronExpression())) {
                this.scheduler.rescheduleJob(TriggerKey.triggerKey((String)this.triggerIdentity), (Trigger)this.createTrigger(cron));
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private CronTrigger createTrigger(String cron) {
        return (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.triggerIdentity).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron).withMisfireHandlingInstructionDoNothing()).build();
    }

    public synchronized boolean isPaused() {
        try {
            return !this.scheduler.isShutdown() && Trigger.TriggerState.PAUSED == this.scheduler.getTriggerState(new TriggerKey(this.triggerIdentity));
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void pauseJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.pauseAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void resumeJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.resumeAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void triggerJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.triggerJob(this.jobDetail.getKey());
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void shutdown() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    @ConstructorProperties(value={"scheduler", "jobDetail", "triggerIdentity"})
    public JobScheduleController(Scheduler scheduler, JobDetail jobDetail, String triggerIdentity) {
        this.scheduler = scheduler;
        this.jobDetail = jobDetail;
        this.triggerIdentity = triggerIdentity;
    }
}

